#ifndef UART_H
#define UART_H

#define UART_TX_ONLY

#define UART_BUFFER_SIZE 32
#define UART_BREAK_CHAR 0x0D

typedef struct {
#ifndef UART_TX_ONLY
    char buffer_in[UART_BUFFER_SIZE];
    volatile char buffer_in_read_ind;
    volatile char buffer_in_write_ind;
    volatile char buffer_in_len;
    volatile char buffer_in_len_tmp;
#endif

    volatile char buffer_out[UART_BUFFER_SIZE];
    volatile char buffer_out_ind;
    volatile char buffer_out_len;
} UART_DATA;

void UART_Init(UART_DATA *data);
void UART_Send_Interrupt_Handler(void);
void UART_Write(const char *string, char length);
void UART_WriteD(const char *string, char length);
#ifndef UART_TX_ONLY
void UART_Recv_Interrupt_Handler(void);
char UART_Buffer_Len(void);
char UART_Read_Buffer(char *buffer);
#endif

#endif
