#include <xc.h>
#include "defines.h"
#include "base_INTERRUPTS.h"
#include "base_UART.h"
#include "base_CPS.h"

void Interrupt_Enable() {
    INTCONbits.GIE = 1;
    INTCONbits.PEIE = 1;
}

void Interrupt_Disable() {
    INTCONbits.GIE = 0;
    INTCONbits.PEIE = 0;
}

void interrupt InterruptHandler(void) {
    char tmr0_rollover = 0;
    
    // Check to see if we have an interrupt on Timer 0 (CPS)
    if (INTCONbits.TMR0IF) {
        CPS_Timer_0_Interrupt_Handler();
        INTCONbits.TMR0IF = 0;
    }
    
//    // Check to see if we have an I2C interrupt
//    if (PIR1bits.SSPIF) {
//        I2C_Interrupt_Handler();
//        PIR1bits.SSPIF = 0;
//    }

#ifndef UART_TX_ONLY
    // Check to see if we have an interrupt on USART1 RX
    if (PIR1bits.RCIF) {
        UART_Recv_Interrupt_Handler();
        PIR1bits.RCIF = 0;
        if (INTCONbits.TMR0IF)
            tmr0_rollover = 1;
    }
#endif

    // Check to see if we have an interrupt on USART1 TX
    if (PIR1bits.TXIF) {
        UART_Send_Interrupt_Handler();
//        PIR1bits.TXIF = 0;
        if (INTCONbits.TMR0IF)
            tmr0_rollover = 1;
    }

    // If Timer 0 rolls over while servicing another interrupt handler,
    //  reset the timers as the sample will be inaccurate.
    if (tmr0_rollover) {
        CPS_Reset();
    }
}
