#ifndef CPS_H
#define	CPS_H

// Size of rolling average buffer
#define CPS_AVG_COUNT 16

// Number of capacitance button inputs
#define CPS_NUM_CHANNELS 2

// Percentage of capacitance change to register button press
#define CPS_PCT_ON 10
#define CPS_PCT_OFF 8

typedef struct {
    char channel;
    char btn_pressed[4];
    unsigned int btn_last_value[4];
    unsigned int btn_avg_value[4];
    char btn_pct_value[4];
} CPS_DATA;

void CPS_Init(CPS_DATA *data);
void CPS_Timer_0_Interrupt_Handler(void);
void CPS_Reset(void);

void CPS_Enable(void);
void CPS_Disable(void);

#endif

