// PIC32MX795F512L

#ifndef DEFINES_H
#define	DEFINES_H

#include <xc.h>
#include <plib.h>
#include <stdint.h>

// Uncomment ONE of the following:
#define CEREBOT_32MX7
// #define CEREBOT_MX7CK

#define CPU_CLOCK_HZ    80000000UL
#define PERIPHERAL_CLOCK_HZ 80000000UL
#define CPU_CT_HZ       (CPU_CLOCK_HZ/2UL)
#define MS_TO_CT_TICKS  (CPU_CLOCK_HZ/2000UL)
#define US_TO_CT_TICKS  (CPU_CLOCK_HZ/2000000UL)

#define ADDRESS_EEPROM 0x50
#define ADDRESS_CONTROLLER_1 0x24
#define ADDRESS_CONTROLLER_2 0x25

// LED1 = G12, LED2 = G13, LED3 = G14, LED4 = G15 (active high)
#define LED1_TRIS TRISGbits.TRISG12
#define LED1_LAT LATGbits.LATG12
#define LED2_TRIS TRISGbits.TRISG13
#define LED2_LAT LATGbits.LATG13
#define LED3_TRIS TRISGbits.TRISG14
#define LED3_LAT LATGbits.LATG14
#define LED4_TRIS TRISGbits.TRISG15
#define LED4_LAT LATGbits.LATG15

// Reset conditions
#define RESET_POR   0x01    // Power on reset
#define RESET_BOR   0x02    // Brown out reset
#define RESET_SWR   0x03    // Software reset
#define RESET_WDT   0x04    // Watchdog timer reset
#define RESET_PIN   0x05    // MCLR pin reset
#define RESET_CFG   0x06    // Config mismatch reset

// Board 'modes' (idle/games/etc)
#define BOARD_MODE_IDLE     0x1
#define BOARD_MODE_SNAKE    0x2
#define BOARD_MODE_TRON     0x3
#define BOARD_MODE_ETHERNET 0x4

void Delay_MS(uint32_t delay_ms);
void Delay_US(uint32_t delay_us);
uint8_t Get_Reset_Condition(void);
uint8_t Get_Board_State(void);
void Reset_Board(uint8_t next_state);
void Idle_Animation_Sequence(void);

#endif /* DEFINES_H */