#ifndef UART1_H
#define UART1_H

#define UART1_BUFFER_SIZE 128

typedef struct {
    void (*rx_callback)(uint8_t c);

    uint8_t buffer_out[UART1_BUFFER_SIZE];
    uint32_t buffer_out_ind;
    uint32_t buffer_out_len;
} UART1_DATA;

void UART1_Init(UART1_DATA *data, void (*rx_callback)(uint8_t));
uint8_t UART1_Write(uint8_t *string, uint32_t length);

#endif  /* UART1_H */
