#ifndef TRON_H
#define	TRON_H

#include "CUBE.h"

#define TRON_MAX_PLAYERS    4
#define TRON_COLLISION      WHITE
#define TRON_COLLISION_2    ORANGE
#define TRON_DELAY          800

typedef struct {
    uint8_t x;
    uint8_t y;
    uint8_t z;
} TRON_POINT;

typedef struct {
    uint8_t Color_Head_R[TRON_MAX_PLAYERS];
    uint8_t Color_Head_G[TRON_MAX_PLAYERS];
    uint8_t Color_Head_B[TRON_MAX_PLAYERS];

    uint8_t Color_Body_R[TRON_MAX_PLAYERS];
    uint8_t Color_Body_G[TRON_MAX_PLAYERS];
    uint8_t Color_Body_B[TRON_MAX_PLAYERS];

    TRON_POINT body[TRON_MAX_PLAYERS][CUBE_PIXELS];
    TRON_POINT direction[TRON_MAX_PLAYERS];
    uint8_t last_direction[TRON_MAX_PLAYERS];
    uint8_t dead[TRON_MAX_PLAYERS];
    uint32_t length[TRON_MAX_PLAYERS];

    uint8_t players;
    uint8_t players_alive;
    uint32_t delay;
} TRON_DATA;

void Tron_Init(TRON_DATA *data);
void Tron_Main(void);
void Tron_Update_Direction(uint8_t controller, CTRL_BTN_STATUS value);
void Tron_Update_Frame(void);

#endif	/* TRON_H */

