#ifndef SPI4_H
#define	SPI4_H

#define SPI4_BUFFER_OUT_SIZE    10
#define SPI4_BUFFER_IN_SIZE     10

typedef struct {
    uint8_t buffer_out[SPI4_BUFFER_OUT_SIZE];
    uint32_t buffer_out_ind;
    uint32_t buffer_out_len;
    uint8_t write_blank;

    uint8_t buffer_in[SPI4_BUFFER_IN_SIZE];
    uint32_t buffer_in_ind;
    uint32_t buffer_in_len;

    void (*tx_callback)(void);
    void (*rx_callback)(uint8_t, uint8_t *);
} SPI4_DATA;

void SPI4_Init(SPI4_DATA *data);
uint8_t SPI4_Read(uint32_t length, void (*rx_callback)(uint8_t, uint8_t *));
uint8_t SPI4_Write(uint8_t *array, uint32_t length, void (*tx_callback)(void));

#endif	/* SPI4_H */

