#ifndef SPI1_H
#define	SPI1_H

#define SPI1_BUFFER_OUT_SIZE    300
//#define SPI1_BUFFER_IN_SIZE     10

#define SPI_WRITE_ONLY

typedef struct {
    uint8_t buffer_out[SPI1_BUFFER_OUT_SIZE];
    uint32_t buffer_out_ind;
    uint32_t buffer_out_len;

    void (*tx_callback)(void);
    void (*rx_callback)(uint8_t);
} SPI1_DATA;

void SPI1_Init(SPI1_DATA *data, void (*rx_callback)(uint8_t));
// Note: SPI1_Write() writes MSB -> LSB!
uint8_t SPI1_Write(uint8_t *array, uint32_t length, void (*tx_callback)(void));

#endif	/* SPI1_H */

