#ifndef SNAKE_H
#define	SNAKE_H

#include "CUBE.h"

#define SNAKE_BODY_COLOR        BLUE
#define SNAKE_HEAD_COLOR        RED
#define SNAKE_CANDY_COLOR       GREEN
#define SNAKE_COLLISION_COLOR   ORANGE

#define SNAKE_MAXIMUM_DELAY 800
#define SNAKE_MINIMUM_DELAY 300

typedef struct {
    uint8_t x;
    uint8_t y;
    uint8_t z;
} SNAKE_POINT;

typedef struct {
    SNAKE_POINT body[CUBE_PIXELS];
    SNAKE_POINT direction;
    SNAKE_POINT candy_loc;
    uint8_t last_direction;
    uint32_t pos_head;
    uint32_t pos_tail;
    uint32_t length;
    uint32_t level;
    uint32_t delay;
} SNAKE_DATA;

void Snake_Init(SNAKE_DATA *data);
void Snake_Main(void);
void Snake_Update_Direction(uint8_t controller, CTRL_BTN_STATUS value);
void Snake_Update_Frame(void);
SNAKE_POINT Snake_Generate_Candy(void);

#endif	/* SNAKE_H */

