#ifndef CONTROLLERS_H
#define	CONTROLLERS_H

#define CONTROLLER_CMD_READ     0xA
#define CONTROLLER_CMD_WRITE    0xB
#define CONTROLLER_CMD_RESET    0xC
#define CONTROLLER_CMD_ACTIVE   0xD

#define CONTROLLER_PREFIX_ADDRESS   0x10
#define CONTROLLER_START_ADDRESS    0x01
#define CONTROLLER_END_ADDRESS      0x08

#define CONTROLLER_MAX_COUNT    8

#define CONTROLLER_BRIGHTNESS_HIGH  0x80

typedef union {
    struct {
        unsigned BTN_L_N    :1;
        unsigned BTN_L_E    :1;
        unsigned BTN_R_E    :1;
        unsigned BTN_R_N    :1;
        unsigned BTN_R_S    :1;
        unsigned BTN_R_W    :1;
        unsigned BTN_L_S    :1;
        unsigned BTN_L_W    :1;
    };
    uint8_t w;
} CTRL_BTN_STATUS;

typedef union {
    struct {
        uint8_t LED_0;
        uint8_t LED_1;
        uint8_t LED_2;
        uint8_t LED_3;
        uint8_t LED_4;
        uint8_t LED_5;
        uint8_t LED_6;
        uint8_t LED_7;
        uint8_t LED_N;
        uint8_t LED_W;
        uint8_t LED_E;
        uint8_t LED_S;
        uint8_t LED_A;
        uint8_t LED_B;
        uint8_t LED_C;
        uint8_t LED_D;
    } single;
    uint8_t w[16];
} CTRL_LED_VALUES;

typedef struct {
    void (*change_callback)(uint8_t controller, CTRL_BTN_STATUS values);

    uint8_t connected_count;
    uint8_t next_poll;
    uint8_t connected_controllers[CONTROLLER_MAX_COUNT];
    CTRL_LED_VALUES led_status[CONTROLLER_MAX_COUNT];
    CTRL_BTN_STATUS btn_prev[CONTROLLER_MAX_COUNT];
    CTRL_BTN_STATUS btn_curr[CONTROLLER_MAX_COUNT];
    
} CONTROLLER_DATA;

void Controller_Init(CONTROLLER_DATA *data,
        void (*change_callback)(uint8_t controller, CTRL_BTN_STATUS values));
void Controller_Poll_Connected(void);
void Controller_Update(void);
void Controller_Set_Left_Leds(uint8_t controller, uint8_t value);
void Controller_Set_Middle_Leds(uint8_t controller, uint8_t value);
void Controller_Set_Right_Leds(uint8_t controller, uint8_t value);

uint8_t Controller_Get_Connected(void);
void Controller_Set_Active(uint8_t controller);
void Controller_Set_Idle(uint8_t controller);

#endif	/* CONTROLLERS_H */

