#ifndef BTN_H
#define	BTN_H

// BTN1 = CN8, BTN2 = CN9, BTN3 = CN19 (32MX7 only)
// BTN1 = RG6, BTN2 = RG7, BTN3 = RD13 (32MX7 only)
// Note: Write to PORTx is effectively the same as write to LATx
#define BTN1_TRIS TRISGbits.TRISG6
#define BTN1_PORT PORTGbits.RG6
#define BTN2_TRIS TRISGbits.TRISG7
#define BTN2_PORT PORTGbits.RG7

#if defined CEREBOT_32MX7
#define BTN3_TRIS TRISDbits.TRISD13
#define BTN3_PORT PORTDbits.RD13
#elif defined CEREBOT_MX7CK
#define BTN3_TRIS TRISAbits.TRISA0
#define BTN3_PORT PORTAbits.RA0
#endif

#define BTN_DEBOUNCE_MS 1

typedef struct {
    void (*callback_function_1)(void);
    void (*callback_function_2)(void);
    void (*callback_function_3)(void);
} BTN_DATA;

void BTN_Init(BTN_DATA *data, void (*callback_1)(void), void (*callback_2)(void), void (*callback_3)(void));

#endif	/* BTN_H */

