#include "defines.h"
#include "BTN.h"

static BTN_DATA *btn_data_ptr;

void BTN_Init(BTN_DATA *data, void (*callback_1)(void), void (*callback_2)(void), void (*callback_3)(void)) {
    btn_data_ptr = data;
    
    btn_data_ptr->callback_function_1 = callback_1;
    btn_data_ptr->callback_function_2 = callback_2;
    btn_data_ptr->callback_function_3 = callback_3;

    BTN1_TRIS = 1;
    BTN2_TRIS = 1;
    BTN3_TRIS = 1;

    INTDisableInterrupts();
    
    CNCONSET = 0x8000;  // Turn on change notice interrupt
#if defined CEREBOT_32MX7
    CNENSET = 0x80300;  // Set interrupt on CN8/9/19
#elif defined CEREBOT_MX7CK
    CNENSET = 0x00300;  // Set interrupt on CN8/9
#endif
    int32_t tmp = BTN1_PORT;
    tmp = BTN2_PORT;
    tmp = BTN3_PORT;
    IPC6SET = 0xD0000;  // Set priority level = 3, sub-priority level = 1
    IFS1CLR = 0x1;      // Clear interrupt flag
    IEC1SET = 0x1;      // Enable interrupt

    INTEnableInterrupts();
}

void __ISR(_CHANGE_NOTICE_VECTOR, ipl3) __CN_Interrupt_Handler(void) {
    // Upon interrupt, debounce input and call saved function
    if (BTN1_PORT == 1) {
        Delay_MS(BTN_DEBOUNCE_MS);
        if (BTN1_PORT == 1) {
            if (btn_data_ptr->callback_function_1 != NULL)
                (*btn_data_ptr->callback_function_1)();
        }
    }
    if (BTN2_PORT == 1) {
        Delay_MS(BTN_DEBOUNCE_MS);
        if (BTN2_PORT == 1) {
            if (btn_data_ptr->callback_function_2 != NULL)
                (*btn_data_ptr->callback_function_2)();
        }
    }
#ifdef CEREBOT_32MX7
    if (BTN3_PORT == 1) {
        Delay_MS(BTN_DEBOUNCE_MS);
        if (BTN3_PORT == 1) {
            if (btn_data_ptr->callback_function_3 != NULL)
                (*btn_data_ptr->callback_function_3)();
        }
    }
#endif
    IFS1CLR = 0x1; // Clear interrupt flag
}