#include "defines.h"
#include "ANIMATIONS.h"
#include "CUBE.h"

void Animation_Solid_Colors(uint16_t delay_ms) {
    Cube_Set_All(RED);
    Delay_MS(delay_ms);
    Cube_Set_All(GREEN);
    Delay_MS(delay_ms);
    Cube_Set_All(BLUE);
    Delay_MS(delay_ms);
}

void Animation_Layer_Alternate(uint16_t delay_ms) {
    uint8_t i;
    for (i = 0; i < CUBE_LAYER_COUNT; i++) {
        if (i % 3 == 0)
            Cube_Set_Layer(i,RED);
        else if (i % 3 == 1)
            Cube_Set_Layer(i,GREEN);
        else
            Cube_Set_Layer(i,BLUE);
    }
    Delay_MS(delay_ms);
    for (i = 0; i < CUBE_LAYER_COUNT; i++) {
        if (i % 3 == 0)
            Cube_Set_Layer(i,GREEN);
        else if (i % 3 == 1)
            Cube_Set_Layer(i,BLUE);
        else
            Cube_Set_Layer(i,RED);
    }
    Delay_MS(delay_ms);
    for (i = 0; i < CUBE_LAYER_COUNT; i++) {
        if (i % 3 == 0)
            Cube_Set_Layer(i,BLUE);
        else if (i % 3 == 1)
            Cube_Set_Layer(i,RED);
        else
            Cube_Set_Layer(i,GREEN);
    }
    Delay_MS(delay_ms);
}

void Animation_Pixel_Alternate(uint16_t delay_ms) {
    uint8_t i,j,k;
    for (i = 0; i < CUBE_LAYER_COUNT; i++) {
        Cube_Clear();
        for (j = 0; j < CUBE_ROW_COUNT; j++) {
            for (k = 0; k < CUBE_COLUMN_COUNT; k++) {
                int32_t var = (j * 8) + k;
                if (var % 3 == 0)
                    Cube_Set_Pixel(i,j,k,RED);
                else if (var % 3 == 1)
                    Cube_Set_Pixel(i,j,k,GREEN);
                else
                    Cube_Set_Pixel(i,j,k,BLUE);
            }
        }
        Delay_MS(delay_ms);
        Cube_Clear();
        for (j = 0; j < CUBE_ROW_COUNT; j++) {
            for (k = 0; k < CUBE_COLUMN_COUNT; k++) {
                int32_t var = (j * 8) + k;
                if (var % 3 == 0)
                    Cube_Set_Pixel(i,j,k,GREEN);
                else if (var % 3 == 1)
                    Cube_Set_Pixel(i,j,k,BLUE);
                else
                    Cube_Set_Pixel(i,j,k,RED);
            }
        }
        Delay_MS(delay_ms);
        Cube_Clear();
        for (j = 0; j < CUBE_ROW_COUNT; j++) {
            for (k = 0; k < CUBE_COLUMN_COUNT; k++) {
                int32_t var = (j * 8) + k;
                if (var % 3 == 0)
                    Cube_Set_Pixel(i,j,k,BLUE);
                else if (var % 3 == 1)
                    Cube_Set_Pixel(i,j,k,RED);
                else
                    Cube_Set_Pixel(i,j,k,GREEN);
            }
        }
        Delay_MS(delay_ms);
    }
}

void Animation_Full_Color_Sweep(uint16_t delay_us) {
    int16_t i;
    for (i = 0; i < 0x0FF; i+=2) {
        Cube_Set_All(i,0,0);
        Delay_US(delay_us);
    }
    for (i = 0; i < 0x0FF; i+=2) {
        Cube_Set_All(0x0FF,i,0);
        Delay_US(delay_us);
    }
    for (i = 0x0FF; i >= 0; i-=2) {
        Cube_Set_All(i,0x0FF,0);
        Delay_US(delay_us);
    }
    for (i = 0; i < 0x0FF; i+=2) {
        Cube_Set_All(0,0x0FF,i);
        Delay_US(delay_us);
    }
    for (i = 0; i < 0x0FF; i+=2) {
        Cube_Set_All(i,0x0FF,0x0FF);
        Delay_US(delay_us);
    }
    for (i = 0x0FF; i >= 0; i-=2) {
        Cube_Set_All(0x0FF,i,0x0FF);
        Delay_US(delay_us);
    }
    for (i = 0x0FF; i >= 0; i-=2) {
        Cube_Set_All(i,0,0x0FF);
        Delay_US(delay_us);
    }
    for (i = 0x0FF; i >= 0; i-=2) {
        Cube_Set_All(0,0,i);
        Delay_US(delay_us);
    }
}

void Animation_Row_Column_Sweep(uint16_t delay_ms) {
    uint8_t i,j,k,a;
    for (i = 0; i < 3; i++) {
        for (j = 0; j < CUBE_ROW_COUNT; j++) {
            Cube_Clear();
            for (k = 0; k < CUBE_COLUMN_COUNT; k++)
                if (i % 3 == 0)
                    for (a = 0; a < CUBE_LAYER_COUNT; a++)
                        Cube_Set_Pixel(a,j,k,RED);
                else if (i % 3 == 1)
                    for (a = 0; a < CUBE_LAYER_COUNT; a++)
                        Cube_Set_Pixel(a,j,k,GREEN);
                else
                    for (a = 0; a < CUBE_LAYER_COUNT; a++)
                        Cube_Set_Pixel(a,j,k,BLUE);
            Delay_MS(delay_ms);
        }
        for (j = 0; j < CUBE_ROW_COUNT; j++) {
            Cube_Clear();
            for (k = 0; k < CUBE_COLUMN_COUNT; k++)
                if (i % 3 == 0)
                    for (a = 0; a < CUBE_LAYER_COUNT; a++)
                        Cube_Set_Pixel(a,k,j,RED);
                else if (i % 3 == 1)
                    for (a = 0; a < CUBE_LAYER_COUNT; a++)
                        Cube_Set_Pixel(a,k,j,GREEN);
                else
                    for (a = 0; a < CUBE_LAYER_COUNT; a++)
                        Cube_Set_Pixel(a,k,j,BLUE);
            Delay_MS(delay_ms);
        }
        for (j = CUBE_LAYER_COUNT; j != 0; j--) {
            Cube_Clear();
            if (i % 3 == 0) {
                for (k = 0; k < CUBE_LAYER_COUNT; k++)
                    if (k == j)
                        Cube_Set_Layer(k,RED);
            } else if (i % 3 == 1) {
                for (k = 0; k < CUBE_LAYER_COUNT; k++)
                    if (k == j)
                        Cube_Set_Layer(k,GREEN);
            } else {
                for (k = 0; k < CUBE_LAYER_COUNT; k++)
                    if (k == j)
                        Cube_Set_Layer(k,BLUE);
            }
            Delay_MS(delay_ms);
        }
    }
}

void Animation_Pixel_Sweep(uint16_t delay_ms) {
    uint8_t i,j,k,a;
    for (a = 0; a < 3; a++) {
        for (i = 0; i < CUBE_LAYER_COUNT; i++) {
            for (j = 0; j < CUBE_ROW_COUNT; j++) {
                for (k = 0; k < CUBE_COLUMN_COUNT; k++) {
                    Cube_Clear();
                    if (a % 3 == 0) {
                        Cube_Set_Pixel(i,j,k,RED);
                    } else if (a % 3 == 1) {
                        Cube_Set_Pixel(i,j,k,GREEN);
                    } else {
                        Cube_Set_Pixel(i,j,k,BLUE);
                    }
                    Delay_MS(delay_ms);
                }
            }
        }
    }
}

void Animation_Pseudo_Random_Colors(uint16_t delay_ms) {
    uint8_t i,j,k;
    for (i = 0; i < CUBE_LAYER_COUNT; i++) {
        for (j = 0; j < CUBE_ROW_COUNT; j++) {
            for (k = 0; k < CUBE_COLUMN_COUNT; k++) {
                uint32_t a = rand();
                if (a % 5 == 0)
                    Cube_Set_Pixel(i,j,k,RED);
                else if (a % 5 == 1)
                    Cube_Set_Pixel(i,j,k,GREEN);
                else if (a % 5 == 2)
                    Cube_Set_Pixel(i,j,k,BLUE);
                else if (a % 5 == 3)
                    Cube_Set_Pixel(i,j,k,PURPLE);
                else if (a % 5 == 4)
                    Cube_Set_Pixel(i,j,k,YELLOW);
                else
                    Cube_Set_Pixel(i,j,k,ORANGE);
            }
        }
    }
    Delay_MS(delay_ms);
}

void Animation_Random_Colors(uint16_t delay_ms) {
    uint8_t i,j,k;
    for (i = 0; i < CUBE_LAYER_COUNT; i++) {
        for (j = 0; j < CUBE_ROW_COUNT; j++) {
            for (k = 0; k < CUBE_COLUMN_COUNT; k++) {
                Cube_Set_Pixel(i,j,k,rand()&0x0FF,rand()&0x0FF,rand()&0x0FF);
            }
        }
    }
    Delay_MS(delay_ms);
}

void Animation_Cube_In_Cube(uint16_t delay_ms) {
    uint8_t x;
    for (x = 0; x < 6; x++) {
        Cube_Clear();
        if (x == 0)
            Cube_Set_Shell(0, RED);
        else if (x == 1 || x == 5)
            Cube_Set_Shell(1, YELLOW);
        else if (x == 2 || x == 4)
            Cube_Set_Shell(2, GREEN);
        else if (x == 3)
            Cube_Set_Shell(3, BLUE);
        Delay_MS(delay_ms);
    }
}

void Animation_Cube_In_Out(uint16_t delay_ms, uint16_t r, uint16_t g, uint16_t b) {
    uint8_t x,i,j,k;
    for (x = 0; x < 7; x++) {
        Cube_Clear();
        switch (x % 7) {
            case 0:
                Cube_Set_Shell(3, r, g, b);
                break;
            case 1:
                Cube_Set_Shell(2, r, g, b);
                break;
            case 2:
                Cube_Set_Shell(1, r, g, b);
                break;
            case 3:
                Cube_Set_Shell(0, r, g, b);
                break;
            case 4:
                Cube_Set_Shell(1, r, g, b);
                break;
            case 5:
                Cube_Set_Shell(2, r, g, b);
                break;
            case 6:
                Cube_Set_Shell(3, r, g, b);
                break;
        }

//        for (i = 0; i < CUBE_LAYER_COUNT; i++) {
//            if ((x == 0 || x == 6)&&(i == 0 || i == 7)) {
//                Cube_Set_Layer(i,r,g,b);
//            } else if ((x == 1 || x == 5)&&(i == 1 || i == 6)) {
//                for (j = 1; j < CUBE_ROW_COUNT-1; j++)
//                    for (k = 1; k < CUBE_COLUMN_COUNT-1; k++)
//                        Cube_Set_Pixel(i,j,k,r,g,b);
//            } else if ((x == 2 || x == 4)&&(i == 2 || i == 5)) {
//                for (j = 2; j < CUBE_ROW_COUNT-2; j++)
//                    for (k = 2; k < CUBE_COLUMN_COUNT-2; k++)
//                        Cube_Set_Pixel(i,j,k,r,g,b);
//            } else if ((x == 3)&&(i == 3 || i == 4)) {
//                for (j = 3; j < CUBE_ROW_COUNT-3; j++)
//                    for (k = 3; k < CUBE_COLUMN_COUNT-3; k++)
//                        Cube_Set_Pixel(i,j,k,r,g,b);
//            }
//
//            if ((x == 0 || x == 6)&&(i > 0 && i < 8)) {
//                for (j = 0; j < 8; j++) {
//                    Cube_Set_Pixel(i,j,0,r,g,b);
//                    Cube_Set_Pixel(i,j,7,r,g,b);
//                    Cube_Set_Pixel(i,0,j,r,g,b);
//                    Cube_Set_Pixel(i,7,j,r,g,b);
//                }
//            }
//            if ((x == 1 || x == 5)&&(i > 1 && i < 7)) {
//                for (j = 1; j < 7; j++) {
//                    Cube_Set_Pixel(i,j,1,r,g,b);
//                    Cube_Set_Pixel(i,j,6,r,g,b);
//                    Cube_Set_Pixel(i,1,j,r,g,b);
//                    Cube_Set_Pixel(i,6,j,r,g,b);
//                }
//            }
//            if ((x == 2 || x == 4)&&(i > 2 && i < 6)) {
//                for (j = 2; j < 6; j++) {
//                    Cube_Set_Pixel(i,j,2,r,g,b);
//                    Cube_Set_Pixel(i,j,5,r,g,b);
//                    Cube_Set_Pixel(i,2,j,r,g,b);
//                    Cube_Set_Pixel(i,5,j,r,g,b);
//                }
//            }
//        }
        Delay_MS(delay_ms);
    }
}

void Animation_Double_Rotation(uint16_t delay_ms) {
    Cube_Clear();
    uint8_t x,y,z;

    for (y = 0; y < CUBE_LAYER_COUNT; y++) {
        Cube_Set_Pixel(y,0,0,RED);
        Cube_Set_Pixel(y,1,1,ORANGE);
        Cube_Set_Pixel(y,2,2,YELLOW);
        Cube_Set_Pixel(y,3,3,GREEN);
        Cube_Set_Pixel(y,4,4,TEAL);
        Cube_Set_Pixel(y,5,5,BLUE);
        Cube_Set_Pixel(y,6,6,PURPLE);
        Cube_Set_Pixel(y,7,7,WHITE);
    }
            
    for (x = 0; x < 28; x++) {
        Delay_MS(delay_ms);
        Cube_Rotate(0);
    }
}

//    for (z = 0; z < 3; z++) {
//        switch (z % 3) {
//            case 0:
//                for (y = 0; y < CUBE_LAYER_COUNT; y++) {
//                    Cube_Set_Pixel(y,0,0,RED);
//                    Cube_Set_Pixel(y,1,1,RED);
//                    Cube_Set_Pixel(y,2,2,RED);
//                    Cube_Set_Pixel(y,3,3,RED);
//                    Cube_Set_Pixel(y,4,4,RED);
//                    Cube_Set_Pixel(y,5,5,RED);
//                    Cube_Set_Pixel(y,6,6,RED);
//                    Cube_Set_Pixel(y,7,7,RED);
//                }
//                break;
//            case 1:
//                for (y = 0; y < CUBE_LAYER_COUNT; y++) {
//                    Cube_Set_Pixel(y,0,0,GREEN);
//                    Cube_Set_Pixel(y,1,1,GREEN);
//                    Cube_Set_Pixel(y,2,2,GREEN);
//                    Cube_Set_Pixel(y,3,3,GREEN);
//                    Cube_Set_Pixel(y,4,4,GREEN);
//                    Cube_Set_Pixel(y,5,5,GREEN);
//                    Cube_Set_Pixel(y,6,6,GREEN);
//                    Cube_Set_Pixel(y,7,7,GREEN);
//                }
//                break;
//            case 2:
//                for (y = 0; y < CUBE_LAYER_COUNT; y++) {
//                    Cube_Set_Pixel(y,0,0,BLUE);
//                    Cube_Set_Pixel(y,1,1,BLUE);
//                    Cube_Set_Pixel(y,2,2,BLUE);
//                    Cube_Set_Pixel(y,3,3,BLUE);
//                    Cube_Set_Pixel(y,4,4,BLUE);
//                    Cube_Set_Pixel(y,5,5,BLUE);
//                    Cube_Set_Pixel(y,6,6,BLUE);
//                    Cube_Set_Pixel(y,7,7,BLUE);
//                }
//                break;
//        }
//
//        for (x = 0; x < 28; x++) {
//            Delay_MS(delay_ms);
//            Cube_Rotate(0);
//        }
//    }
//}

void Animation_Wave1(uint16_t delay_ms) {
    uint8_t i, j;
    static uint8_t data[8];
    uint32_t r;
    
    for (i = 0; i < 16; i++) {
        for (j = 0; j < 8; j++) {
            r = rand();
            if (r % 3 == 0) {
                // Increase
                data[j] = (data[j] == CUBE_LAYER_COUNT) ? data[j] : data[j] + 1;
            } else if (r % 3 == 1) {
                // Decrease
                data[j] = (data[j] == 0) ? data[j] : data[j] - 1;
            } else {
                // No change
                data[j] = data[j];
            }
        }
        Cube_Shift_Waterfall(data);
        Delay_MS(delay_ms);
    }
}

void Animation_Wave2(uint16_t delay_ms) {
    uint8_t i, j;
    static uint8_t data[8];
    uint32_t r;

    for (i = 0; i < 16; i++) {
        for (j = 0; j < 8; j++) {
            r = rand();
            if (r % 3 == 0) {
                // Increase
                data[j] = (data[j] == CUBE_LAYER_COUNT) ? data[j] : data[j] + 1;
            } else if (r % 3 == 1) {
                // Decrease
                data[j] = (data[j] == 0) ? data[j] : data[j] - 1;
            } else {
                // No change
                data[j] = data[j];
            }
        }
        Cube_Shift_Waterfall2(data);
        Delay_MS(delay_ms);
    }
}

void Animation_Sphere(uint16_t delay_ms) {
    Cube_Clear();
    Cube_Set_Sphere(0, RED);
    Delay_MS(delay_ms);
    Cube_Clear();
    Cube_Set_Sphere(1, ORANGE);
    Delay_MS(delay_ms);
    Cube_Clear();
    Cube_Set_Sphere(2, YELLOW);
    Delay_MS(delay_ms);
    Cube_Clear();
    Cube_Set_Sphere(3, GREEN);
    Delay_MS(delay_ms);
    Cube_Clear();
    Cube_Set_Sphere(4, BLUE);
    Delay_MS(delay_ms);
    Cube_Clear();
    Cube_Set_Sphere(5, PURPLE);
    Delay_MS(delay_ms);
    Cube_Clear();
    Cube_Set_Sphere(6, RED);
    Delay_MS(delay_ms);
    Cube_Clear();
    Cube_Set_Sphere(7, ORANGE);
    Delay_MS(delay_ms);
    Cube_Clear();
    Cube_Set_Sphere(8, YELLOW);
    Delay_MS(delay_ms);
    Cube_Clear();
    Cube_Set_Sphere(7, ORANGE);
    Delay_MS(delay_ms);
    Cube_Clear();
    Cube_Set_Sphere(6, RED);
    Delay_MS(delay_ms);
    Cube_Clear();
    Cube_Set_Sphere(5, PURPLE);
    Delay_MS(delay_ms);
    Cube_Clear();
    Cube_Set_Sphere(4, BLUE);
    Delay_MS(delay_ms);
    Cube_Clear();
    Cube_Set_Sphere(3, GREEN);
    Delay_MS(delay_ms);
    Cube_Clear();
    Cube_Set_Sphere(2, YELLOW);
    Delay_MS(delay_ms);
    Cube_Clear();
    Cube_Set_Sphere(1, ORANGE);
    Delay_MS(delay_ms);
    Cube_Clear();
}

void Animation_Sawtooth(uint16_t delay_ms) {
    uint8_t i;
    uint8_t dir = 1;
    uint8_t layer_dir = 1;
    uint8_t layer_min = 0;
    uint8_t layer_max = CUBE_LAYER_COUNT;
    uint8_t layer = layer_min;

    for (i = 0; i < 48; i++) {
        Cube_Set_Row(7, 0x00, 0x00, 0x00);
        Cube_Set_Pixel(layer, 7, 0, RED);
        Cube_Set_Pixel(layer, 7, 1, ORANGE);
        Cube_Set_Pixel(layer, 7, 2, YELLOW);
        Cube_Set_Pixel(layer, 7, 3, GREEN);
        Cube_Set_Pixel(layer, 7, 4, TEAL);
        Cube_Set_Pixel(layer, 7, 5, BLUE);
        Cube_Set_Pixel(layer, 7, 6, PURPLE);
        Cube_Set_Pixel(layer, 7, 7, WHITE);
        
        if (dir)
            layer++;
        else
            layer--;

        // Decrease the maximum layer
        if (layer == layer_min) {
            dir = 1;
            if (layer_dir)
                layer_max--;
            else
                layer_max++;
        }

        // Increase the minimum layer
        if (layer == layer_max - 1) {
            dir = 0;
            if (layer_dir)
                layer_min++;
            else
                layer_min--;
        }

        // Change the layer gap to expansion
        if (layer_max - layer_min < 3) {
            if (layer_dir)
                layer_dir = 0;
            else
                layer_dir = 1;
        }

        // Change the layer gap to reduction
        if (layer == 0) {
            if (layer_dir)
                layer_dir = 0;
            else
                layer_dir = 1;
        }
        
        Delay_MS(delay_ms);
        Cube_Shift_Row(0);
    }
}
