// <editor-fold defaultstate="collapsed" desc="Configuration Bits">
/* ------------------------------------------------------------ */
/* PIC32 Configuration Settings */
/* ------------------------------------------------------------ */
/* Oscillator Settings */
#pragma config FNOSC     = PRIPLL   // Oscillator Selection Bits
#pragma config POSCMOD   = EC       // Primary Oscillator Configuration
#pragma config FPLLIDIV  = DIV_2    // PLL Input Divider
#pragma config FPLLMUL   = MUL_20   // PLL Multiplier
#pragma config FPLLODIV  = DIV_1    // PLL Output Divider
#pragma config FPBDIV    = DIV_1    // Peripheral Clock Divisor (timers/UART/SPI/I2C)
#pragma config FSOSCEN   = OFF      // Secondary Oscillator Enable
/* Clock Control Settings */
#pragma config IESO      = OFF      // Internal/External Clock Switch Over
#pragma config FCKSM     = CSDCMD   // Clock Switching and Monitor Selection
#pragma config OSCIOFNC  = OFF      // CLKO Output Signal Active on the OSCO Pin
/* USB Settings */
#pragma config UPLLEN    = ON       // USB PLL Enable
#pragma config UPLLIDIV  = DIV_2    // USB PLL Input Divider
#pragma config FVBUSONIO = OFF      // USB VBUS ON Selection
#pragma config FUSBIDIO  = OFF      // USB USID Selection
/* Other Peripheral Device Settings */
#pragma config FWDTEN    = OFF      // Watchdog Timer Enable
#pragma config WDTPS     = PS1048576    // Watchdog Timer Postscaler (1048.576s)
#pragma config FSRSSEL   = PRIORITY_7   // SRS Interrupt Priority
#pragma config FCANIO    = OFF      // CAN I/O Pin Select (default/alternate)
#pragma config FETHIO    = ON       // Ethernet I/O Pin Select (default/alternate)
#pragma config FMIIEN    = OFF      // Ethernet MII/RMII select (OFF=RMII)
/* Code Protection Settings */
#pragma config CP        = OFF      // Code Protect
#pragma config BWP       = OFF      // Boot Flash Write Protect
#pragma config PWP       = OFF      // Program Flash Write Protect
/* Debug Settings */
#pragma config ICESEL = ICS_PGx1    // ICE/ICD Comm Channel Select (on-board debugger)
/* ------------------------------------------------------------ */
// </editor-fold>

#include "defines.h"
#include "ETHERNET.h"

void Delay_MS(uint32_t delay_ms) {
    // Delays the CPU for the given amount of time.
    // Note: Watch out for integer overflow! (max delay_ms = 107374) ??
    uint32_t delay = delay_ms * MS_TO_CT_TICKS;
    uint32_t startTime = ReadCoreTimer();
    while ((uint32_t)(ReadCoreTimer() - startTime) < delay) {};
}

void Delay_US(uint32_t delay_us) {
    // Delays the CPU for the given amount of time.
    // Note: Watch out for integer overflow!
    uint32_t delay = delay_us * US_TO_CT_TICKS;
    uint32_t startTime = ReadCoreTimer();
    while ((uint32_t)(ReadCoreTimer() - startTime) < delay) {};
}

int main(void) {
    /* -------------------- BEGIN INITIALIZATION --------------------- */

    // Configure the target for maximum performance at 80 MHz.
    // Note: This overrides the peripheral clock to 80Mhz regardless of config
    SYSTEMConfigPerformance(CPU_CLOCK_HZ);

    // Configure the interrupts for multiple vectors
    INTConfigureSystem(INT_SYSTEM_CONFIG_MULT_VECTOR);

    // Set all analog I/O pins to digital
    AD1PCFGSET = 0xFFFF;

    // Enable the watchdog timer with windowed mode disabled
    // WDT prescaler set to 1048576 (1048.576s) (see config bits)
//    WDTCON = 0x00008000;

    LED1_TRIS = 0;
    LED2_TRIS = 0;
    LED3_TRIS = 0;
    LED4_TRIS = 0;
    LED1_LAT = 0;
    LED2_LAT = 0;
    LED3_LAT = 0;
    LED4_LAT = 0;

    ETH_DATA eth_data;
    
    ETH_Init(&eth_data, NULL, NULL);

    uint8_t buffer[3000] = {0};
    buffer[0] = 0xAA;
    buffer[2017] = 0xBB;
    buffer[2018] = 0xCC;
    buffer[2999] = 0xDD;
    

    ETH_MAC_ADDRESS dest = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    ETH_MAC_ADDRESS src = {0x00, 0x18, 0x3E, 0x00, 0xD7, 0xEB};

//    ETH_Write_Packet(dest, src, 2018, buffer);
    
    ETH_Write_Packet(dest, src, 2018, buffer);
    ETH_Write_Packet(dest, src, 2018, buffer);
    ETH_Write_Packet(dest, src, 2018, buffer);
    ETH_Write_Packet(dest, src, 2018, buffer);

    while (1) {
        uint8_t queue = ETH_Recv_Queue();
        if (queue != 0) {
            LED1_LAT = 1;
        }
    }
    
}

