#ifndef SERIALWIDGET_H
#define SERIALWIDGET_H

#include "GlobalDefines.h"
#include "SerialHelper.h"

class SerialWidget : public QWidget
{
        Q_OBJECT
    public:
        SerialWidget(QWidget *parent = 0);
        ~SerialWidget();

    public slots:
        // Inbound from SerialHelper
        void UpdateParameters(QStringList ports, QStringList speeds, QStringList dataBits,
                              QStringList stopBits, QStringList parity, QStringList flowControl);

        // Local GUI processing
        void ConnectToggleBtn(void);
        void LocalConnected(bool);

    signals:
        // Outbound to SerialHelper
        void QueryParameters(void);
        void Connect(QString port, QString speed, QString dataBits,
                     QString stopBits, QString parity, QString flowControl);
        void Disconnect(void);
        void TransmitByteArray(QByteArray data);

        // Outbound to MainWindow
        void ReceivedByte(QByteArray data);
        void Connected(bool);
        void UpdateStatus(QString string);

    private:
        SerialHelper *serialHelper;
        QThread *serialThread;

        QPushButton *btnConnect;
        QPushButton *btnRefresh;
        QLabel *labelPort;
        QLabel *labelSpeed;
        QLabel *labelDataBits;
        QLabel *labelStopBits;
        QLabel *labelParity;
        QLabel *labelFlowControl;
        QComboBox *cboxPort;
        QComboBox *cboxSpeed;
        QComboBox *cboxDataBits;
        QComboBox *cboxStopBits;
        QComboBox *cboxParity;
        QComboBox *cboxFlowControl;
};

#endif // SERIALWIDGET_H
