#include "SerialWidget.h"

SerialWidget::SerialWidget(QWidget *parent) : QWidget(parent)
{
    // Serial connection UI
    btnConnect = new QPushButton("&Connect");
    btnRefresh = new QPushButton("&Refresh");
    labelPort = new QLabel("Serial Port:");
    labelSpeed = new QLabel("Baud Rate:");
    labelDataBits = new QLabel("Data:");
    labelStopBits = new QLabel("Stop:");
    labelParity = new QLabel("Parity Bit:");
    labelFlowControl = new QLabel("Flow Control:");
    cboxPort = new QComboBox();
    cboxPort->setMinimumWidth(80);
    cboxSpeed = new QComboBox();
    cboxSpeed->setEditable(true);
    cboxSpeed->setValidator(new QIntValidator(0, 100000000, this));
    cboxDataBits = new QComboBox();
    cboxDataBits->setMaximumWidth(60);
    cboxStopBits = new QComboBox();
    cboxStopBits->setMaximumWidth(60);
    cboxParity = new QComboBox();
    cboxFlowControl = new QComboBox();
    cboxFlowControl->setMinimumWidth(70);

    QGridLayout *serialSettingsLayout = new QGridLayout();
    serialSettingsLayout->addWidget(btnConnect, 0, 0);
    serialSettingsLayout->addWidget(labelPort, 0, 1);
    serialSettingsLayout->addWidget(cboxPort, 0, 2);
    serialSettingsLayout->addWidget(labelDataBits, 0, 3);
    serialSettingsLayout->addWidget(cboxDataBits, 0, 4);
    serialSettingsLayout->addWidget(labelParity, 0, 5);
    serialSettingsLayout->addWidget(cboxParity, 0, 6);

    serialSettingsLayout->addWidget(btnRefresh, 1, 0);
    serialSettingsLayout->addWidget(labelSpeed, 1, 1);
    serialSettingsLayout->addWidget(cboxSpeed, 1, 2);
    serialSettingsLayout->addWidget(labelStopBits, 1, 3);
    serialSettingsLayout->addWidget(cboxStopBits, 1, 4);
    serialSettingsLayout->addWidget(labelFlowControl, 1, 5);
    serialSettingsLayout->addWidget(cboxFlowControl, 1, 6);

    setLayout(serialSettingsLayout);

    serialHelper = new SerialHelper();
    serialThread = new QThread();
    serialHelper->moveToThread(serialThread);

    connect(serialHelper, SIGNAL(UpdateStatus(QString)), this, SIGNAL(UpdateStatus(QString)));

    connect(this, SIGNAL(QueryParameters()), serialHelper, SLOT(QueryParameters()));
    connect(serialHelper, SIGNAL(UpdateParameters(QStringList,QStringList,QStringList,QStringList,QStringList,QStringList)),
            this, SLOT(UpdateParameters(QStringList,QStringList,QStringList,QStringList,QStringList,QStringList)));

    connect(this, SIGNAL(Connect(QString,QString,QString,QString,QString,QString)),
            serialHelper, SLOT(Connect(QString,QString,QString,QString,QString,QString)));
    connect(serialHelper, SIGNAL(Connected(bool)), this, SIGNAL(Connected(bool)));
    connect(serialHelper, SIGNAL(Connected(bool)), this, SLOT(LocalConnected(bool)));

    connect(this, SIGNAL(Disconnect()), serialHelper, SLOT(Disconnect()));

    connect(this, SIGNAL(TransmitByteArray(QByteArray)), serialHelper, SLOT(TransmitByteArray(QByteArray)));

    connect(serialHelper, SIGNAL(ReceivedByte(QByteArray)), this, SIGNAL(ReceivedByte(QByteArray)));

    connect(serialThread, SIGNAL(finished()), serialHelper, SLOT(deleteLater()));
    serialThread->start();

    connect(btnConnect, SIGNAL(clicked()), this, SLOT(ConnectToggleBtn()));
    connect(btnRefresh, SIGNAL(clicked()), this, SIGNAL(QueryParameters()));

    emit QueryParameters();
    LocalConnected(false);
}

SerialWidget::~SerialWidget()
{
    serialThread->quit();
}

void SerialWidget::UpdateParameters(QStringList ports, QStringList speeds, QStringList dataBits,
                                               QStringList stopBits, QStringList parity, QStringList flowControl)
{
    QString currPort = cboxPort->currentText();
    cboxPort->clear();
    cboxPort->addItems(ports);
    if (currPort != "" && ports.contains(currPort))
        cboxPort->setCurrentText(currPort);

    QString currSpeed = cboxSpeed->currentText();
    cboxSpeed->clear();
    cboxSpeed->addItems(speeds);
    if (currSpeed != "") cboxSpeed->setCurrentText(currSpeed);

    int currData = cboxDataBits->currentIndex();
    cboxDataBits->clear();
    cboxDataBits->addItems(dataBits);
    if (currData >= 0) cboxDataBits->setCurrentIndex(currData);

    int currStop = cboxStopBits->currentIndex();
    cboxStopBits->clear();
    cboxStopBits->addItems(stopBits);
    if (currStop >= 0) cboxStopBits->setCurrentIndex(currStop);

    int currParity = cboxParity->currentIndex();
    cboxParity->clear();
    cboxParity->addItems(parity);
    if (currParity >= 0) cboxParity->setCurrentIndex(currParity);

    int currFlow = cboxFlowControl->currentIndex();
    cboxFlowControl->clear();
    cboxFlowControl->addItems(flowControl);
    if (currFlow >= 0) cboxFlowControl->setCurrentIndex(currFlow);
}

void SerialWidget::LocalConnected(bool connected)
{
    if (connected) {
        btnConnect->setText("&Disconnect");
        btnRefresh->hide();
        labelPort->hide();
        labelSpeed->hide();
        labelDataBits->hide();
        labelStopBits->hide();
        labelParity->hide();
        labelFlowControl->hide();
        cboxPort->hide();
        cboxSpeed->hide();
        cboxDataBits->hide();
        cboxStopBits->hide();
        cboxParity->hide();
        cboxFlowControl->hide();
    } else {
        btnConnect->setText("&Connect");
        btnRefresh->show();
        labelPort->show();
        labelSpeed->show();
        labelDataBits->show();
        labelStopBits->show();
        labelParity->show();
        labelFlowControl->show();
        cboxPort->show();
        cboxSpeed->show();
        cboxDataBits->show();
        cboxStopBits->show();
        cboxParity->show();
        cboxFlowControl->show();
    }
}

void SerialWidget::ConnectToggleBtn()
{
    if (serialHelper->connected) {
        emit Disconnect();
    } else {
        if (cboxPort->currentText() != "" && cboxSpeed->currentText() != "") {
            emit Connect(cboxPort->currentText(), cboxSpeed->currentText(), cboxDataBits->currentText(),
                                cboxStopBits->currentText(), cboxParity->currentText(), cboxFlowControl->currentText());
        }
    }
}

//void SerialController::Serial_ProcessIncomingData()
//{
//    char tmpBuffer[SERIAL_BUFFER_SIZE];
//    int len = serialPort->read(tmpBuffer, sizeof(tmpBuffer));
//    while (len > 0) {
//        for (int i = 0; i < len; i++) {
//            // Save received data into local buffer
//            bufferIn[bufferInIndex] = tmpBuffer[i];

//            // If newline char is received, end current string
//            if (tmpBuffer[i] == '\n') {
//                if (bufferInOverflow)
//                    currString.append(QString::fromLocal8Bit(bufferIn, bufferInIndex));
//                else
//                    currString = QString::fromLocal8Bit(bufferIn, bufferInIndex);
//                bufferInOverflow = false;
//                bufferInIndex = 0;
//                emit Serial_ReceivedString(currString);
//            } else {
//                bufferInIndex++;
//            }

//            // If received string is larger than our serial buffer, append to previous data
//            if (bufferInIndex == SERIAL_BUFFER_SIZE-1) {
//                bufferIn[SERIAL_BUFFER_SIZE-1] = 0x0;
//                if (bufferInOverflow)
//                    currString.append(QString::fromLocal8Bit(bufferIn, bufferInIndex));
//                else
//                    currString = QString::fromLocal8Bit(bufferIn, bufferInIndex);
//                bufferInOverflow = true;
//                bufferInIndex = 0;
//            }
//        }
//        // Check if there is more data to be read from the serial port
//        len = serialPort->read(tmpBuffer, sizeof(tmpBuffer));
//    }
//}
