#ifndef SERIALHELPER_H
#define SERIALHELPER_H

#include "GlobalDefines.h"
#include <QtSerialPort>

#define SERIAL_NEWLINE_CHAR "\n"
#define SERIAL_BUFFER_SIZE	32

class SerialHelper : public QObject
{
        Q_OBJECT
    public:
        SerialHelper(QObject *parent = 0);
        ~SerialHelper();

        bool connected;

    public slots:
        // Inbound from SerialController
        void QueryParameters(void);
        void Connect(QString port, QString speed, QString dataBits,
                     QString stopBits, QString parity, QString flowControl);
        void Disconnect(bool errored = false);
        void TransmitString(QString string);
        void TransmitByteArray(QByteArray data);

        // Local processing of received data
        void ProcessIncomingData(void);
        void ProcessError(QSerialPort::SerialPortError error);

    signals:
        // Outbound to SerialController
        void UpdateParameters(QStringList ports, QStringList speeds, QStringList dataBits,
                              QStringList stopBits, QStringList parity, QStringList flowControl);
        void ReceivedByte(QByteArray);
        void Connected(bool);
        void UpdateStatus(QString string);

    private:
        QSerialPort *serialPort;
        QStringList speeds;
        QStringList dataBits;
        QStringList stopBits;
        QStringList parity;
        QStringList flowControl;

        char bufferIn[SERIAL_BUFFER_SIZE];
        int bufferInIndex;
        bool bufferInOverflow;
        QString currString;
};

#endif // SERIALHELPER_H
