#ifndef PASTECONTROLLER_H
#define PASTECONTROLLER_H

#include "GlobalDefines.h"

#define BTN_ICON_SIZE 32
#define X_MIN 0
#define X_MAX 290
#define Y_MIN 0
#define Y_MAX 270
#define Z_MIN 0
#define Z_MAX 240

#define SLOW_MULTIPLIER 4

class PasteController : public QWidget
{
        Q_OBJECT
    public:
        PasteController(QWidget *parent = 0);
        ~PasteController();

    signals:
        void EnableControls(void);
        void DisableControls(void);
        void TransmitData(QByteArray);
        void UpdateStatus(QString);

    public slots:
        void EnableTransmit(bool);
        void InitializePrinter(void);
        void ToggleHotkeys(void);
        void MoveToolhead(void);
        void MoveToolheadSingle(void);
        void UpdatePosition(void);
        void ExtrudeSingle(void);
        void ResetPosition(void);
        void ProcessData(QByteArray);
        void SetBaseHeight(void);

        void QSliderToQDoubleSpinBox(int);
        void QDoubleSpinBoxToQSlider(double);

    protected:
        bool eventFilter(QObject *, QEvent *);

    private:
        bool connected;
        bool hotkeysEnabled;
        double xPos,yPos,zPos;
        bool X_Incr, X_Decr, Y_Incr, Y_Decr, Z_Incr, Z_Decr, E_Incr;
        bool transmittingData;

        void IncrementToolhead(double x, double y, double z);
        void SingleExtrude(void);

        QQueue<QString> *queueCmds;
        QTimer *tmrUpdate;

        QLabel *labelHelp;

        QPushButton *btnEnableHotkeys;
        QPushButton *btnInit;
        QPushButton *btnHome;

        // Printer control buttons
        QToolButton *btnForward;
        QToolButton *btnBackward;
        QToolButton *btnLeft;
        QToolButton *btnRight;
        QToolButton *btnUp;
        QToolButton *btnDown;
        QToolButton *btnExtrude;

        // Toolhead position elements
        QLabel *labelXPos;
        QLineEdit *textXValue;
        QLabel *labelYPos;
        QLineEdit *textYValue;
        QLabel *labelZPos;
        QLineEdit *textZValue;

        // Movement setting elements
        QLabel *labelXYSteps;
        QSlider *sliderXYSteps;
        QDoubleSpinBox *textXYSteps;

        QLabel *labelXYSpeed;
        QSlider *sliderXYSpeed;
        QSpinBox *textXYSpeed;

        QLabel *labelZSteps;
        QSlider *sliderZSteps;
        QDoubleSpinBox *textZSteps;

        QLabel *labelZSpeed;
        QSlider *sliderZSpeed;
        QSpinBox *textZSpeed;

        QLabel *labelRepeatDelay;
        QSlider *sliderRepeatDelay;
        QSpinBox *textRepeatDelay;

        // Extruder setting elements
        QLabel *labelEForwardSteps;
        QSlider *sliderEForwardSteps;
        QDoubleSpinBox *textEForwardSteps;

        QLabel *labelEForwardSpeed;
        QSlider *sliderEForwardSpeed;
        QSpinBox *textEForwardSpeed;

        QLabel *labelEBackwardSteps;
        QSlider *sliderEBackwardSteps;
        QDoubleSpinBox *textEBackwardSteps;

        QLabel *labelEBackwardSpeed;
        QSlider *sliderEBackwardSpeed;
        QSpinBox *textEBackwardSpeed;

        QLabel *labelExtrusionHeight;
        QSlider *sliderExtrusionHeight;
        QDoubleSpinBox *textExtrusionHeight;

        QLabel *labelEZSteps;
        QSlider *sliderEZSteps;
        QDoubleSpinBox *textEZSteps;

};

#endif // PASTECONTROLLER_H
