#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "GlobalDefines.h"
#include "SerialWidget.h"
#include "MacroWidget.h"
#include "IOWidget.h"
#include "PasteController.h"
#include "GerberParser.h"

class MainWindow : public QMainWindow
{
        Q_OBJECT
    public:
        MainWindow(QWidget *parent = 0);
        ~MainWindow();

    public slots:
        void UpdateStatus(QString string);
        void UpdateSerialStatus(QString string);
        void ToggleGroupLayout(bool);

    signals:
        void Serial_TransmitByteArray(QByteArray data);

    protected:

    private:
        QWidget *centralWidget;

        // Serial controller + UI
        SerialWidget *serialWidget;
        QGroupBox *groupSerialInit;
        QPushButton *btnSerialConnect;

        // Serial data
        IOWidget *ioWidget;
        QGroupBox *groupSerialData;

        QGroupBox *groupOther;

        // Macro controller + UI
        MacroWidget *macroWidget;
        QDockWidget *macroDockWidget;
        QPushButton *btnMacro;

        // Paste controller + UI
        PasteController *pasteWidget;
        QDockWidget *pasteDockWidget;
        QPushButton *btnPaste;

        // Status bar
        QLabel *labelSerialStatus;

};

#endif // MAINWINDOW_H
