#ifndef MACROWIDGET_H
#define MACROWIDGET_H

#include "GlobalDefines.h"

#define MACRO_DEFAULT_COUNT 4

class MacroWidget : public QWidget
{
        Q_OBJECT
    public:
        MacroWidget(QWidget *parent = 0);
        ~MacroWidget();

        QSize sizeHint() const;

    public slots:
        // *public* slots
        void EnableTransmit(bool);
        // *private* slots
        void InitTransmit(QWidget* t);
        void KeybindPrompt(int id);
        void AddEntry(void);
        void RemoveEntry(void);
        void Clear(void);
        void WriteToFile(void);
        void ReadFromFile(void);

    signals:
        void TransmitText(QByteArray data);

    protected:
        bool eventFilter(QObject *, QEvent *);

    private:
        int count;
        bool connected;
        QString lastKnownFilePath;

        QPushButton *btnExport;
        QPushButton *btnImport;
        QPushButton *btnAddMacro;
        QPushButton *btnRemoveMacro;
        QPushButton *btnClear;

        QList<QLineEdit*> nameList;
        QList<QTextEdit*> valueList;
        QList<QPushButton*> btnSendList;
        QList<QPushButton*> btnKeyList;

        QList<QKeySequence> registeredKeySequences;
        QList<int> registeredKeyMacroIDs;

        QGridLayout *mainLayout;
        QHBoxLayout *ioLayout;
        QSignalMapper *sigmapTransmit;
        QSignalMapper *sigmapKeybind;

        QPair<QPushButton*,int> currKeyBindInfo;
};

#endif // MACROWIDGET
