#ifndef IOWIDGET_H
#define IOWIDGET_H

#include "GlobalDefines.h"

class IOWidget : public QWidget
{
        Q_OBJECT
    public:
        IOWidget(QWidget *parent = 0);
        ~IOWidget();

    public slots:
        void PreprocessTransmit(QByteArray data = QByteArray());
        void ProcessReceivedByte(QByteArray data);
        void ClearBtn(void);
        void EnableTransmit(bool);

    signals:
        void TransmitByteArray(QByteArray data);

    private:
        QTextEdit *textData;
        QLineEdit *textTransmit;
        QPushButton *btnTransmit;
        QPushButton *btnClear;

        bool lastTransmit;
};

#endif // IOWIDGET_H
