#include "IOWidget.h"

IOWidget::IOWidget(QWidget *parent) : QWidget(parent)
{
    // Serial data UI
    textData = new QTextEdit();
    textData->setCurrentFont(QFont("Consolas", 8));
    textData->append("Waiting for serial connection... ");
    textData->setMinimumSize(400, 100);
    textData->setReadOnly(true);
    textTransmit = new QLineEdit();
    textTransmit->setEnabled(false);
    textTransmit->setFont(QFont("Consolas", 8));
    btnTransmit = new QPushButton("&Send");
    btnTransmit->setEnabled(false);
    btnClear = new QPushButton("Clear");

    QHBoxLayout *transmitLayout = new QHBoxLayout();
    transmitLayout->addWidget(textTransmit);
    transmitLayout->addWidget(btnTransmit);
    transmitLayout->addWidget(btnClear);
    QVBoxLayout *dataLayout = new QVBoxLayout();
    dataLayout->addWidget(textData);
    dataLayout->addLayout(transmitLayout);
    setLayout(dataLayout);

    connect(btnTransmit, SIGNAL(clicked()), this, SLOT(PreprocessTransmit()));
    connect(textTransmit, SIGNAL(returnPressed()), btnTransmit, SIGNAL(clicked()));
    connect(btnClear, SIGNAL(clicked()), this, SLOT(ClearBtn()));

//    EnableTransmit(false);
    textTransmit->setEnabled(false);
    btnTransmit->setEnabled(false);
    lastTransmit = true;
}

IOWidget::~IOWidget()
{

}

void IOWidget::PreprocessTransmit(QByteArray data)
{
    QString str;
    if (data.isEmpty()) {
        str = textTransmit->text();
        textTransmit->setText("");
    } else {
        str = QString(data);
    }

    QTime curTime = QTime::currentTime();
    QStringList cmds = str.split('\n', QString::SkipEmptyParts);
    for (int i = 0; i < cmds.size(); i++) {
        emit TransmitByteArray((cmds[i] + '\n').toUtf8());
        textData->setTextColor(Qt::darkBlue);
        textData->append(curTime.toString("[HH:mm:ss:zzz]: ") + cmds[i]);
    }
    textData->moveCursor(QTextCursor::End);
    textData->ensureCursorVisible();

    // Save a flag indicating last activity was a transmit
    lastTransmit = true;
}

void IOWidget::ProcessReceivedByte(QByteArray data)
{
    textData->setTextColor(Qt::darkRed);
    QTime curTime = QTime::currentTime();
    QString timeString = "\n" + curTime.toString("[HH:mm:ss:zzz]: ");
    if (data.endsWith('\n')) data.remove(data.size()-1, 1);
    data.replace('\n', timeString);
    if (lastTransmit) {
        textData->insertPlainText(timeString + QString(data));
    } else {
        textData->insertPlainText(QString(data));
    }
    textData->moveCursor(QTextCursor::End);
    textData->ensureCursorVisible();
    lastTransmit = false;
}

void IOWidget::ClearBtn()
{
    textData->clear();
}

void IOWidget::EnableTransmit(bool enable)
{
    textData->setTextColor(Qt::black);
    if (enable) {
        textTransmit->setEnabled(true);
        btnTransmit->setEnabled(true);
        textData->insertPlainText("connected!");
    } else {
        textTransmit->setEnabled(false);
        btnTransmit->setEnabled(false);
        textData->append("Serial disconnected.");
        textData->append("Waiting for serial connection... ");
    }
    textData->moveCursor(QTextCursor::End);
    textData->ensureCursorVisible();
}
