#include <msp430.h> 

int main(void) {
    WDTCTL = WDTPW | WDTHOLD;	// Stop watchdog timer
	
    /* --- Set Oscillator Settings ---------------------- */
	BCSCTL1 = XT2OFF;           // Turn off XT2 oscillator, ACLK = low freq mode/1
	BCSCTL1 = CALBC1_16MHZ;      // Set DCO to callibrated 16Mhz
	DCOCTL  = CALDCO_16MHZ;      // Set DCO to callibrated 16Mhz
	BCSCTL2 = SELM_0 | DIVM_0 | DIVS_3; // MCLK = DCO/1, SMCLK = MCLK/8
	BCSCTL3 = LFXT1S_0 | XCAP_2;        // LFXT1 = 32.768khz, 10pF termination
	IE1 &= ~OFIE;               // Disable oscillator fault interrupt
	/* -------------------------------------------------- */

//	/* --- Set Timer Settings --------------------------- */
//	// Timer A clock source = ACLK/1, continuous mode, interrupt enabled
//	TA0CTL = TASSEL_1 | ID_0 | MC_2 | TACLR | TAIE;
//	TACCTL0 = CCIE;     // Enable timer A comparator 0 interrupt
//	TACCR0  = 32768;    // Set initial comparator value
//	/* -------------------------------------------------- */

	UCB0CTL0 = UCMSB+UCMST+UCMODE_0;		// 3-pin, 8-bit SPI master
	UCB0CTL1 = UCSSEL_2+UCSWRST;				// SMCLK
	UCB0BR0 = 2;								// UCLK/2
	UCB0BR1 = 0;
	//UCB0MCTL = 0;
	P1SEL |= BIT5 + BIT6 + BIT7;
	P1SEL2 |= BIT5 + BIT6 + BIT7;
	P1OUT |= BIT5 + BIT6 + BIT7;
	P1DIR |= BIT5 + BIT7;
	P1DIR &= ~BIT6;
	UCB0CTL1 &= ~UCSWRST;						// **Initialize USCI state machine**

//	/* --- Set Port Settings ---------------------------- */
//	// Set port direction to output
//	P1DIR = BIT0 | BIT6;
//	// Set initial port values
//	P1OUT = ~(BIT0 | BIT6);
//	/* -------------------------------------------------- */

	// Go into low power mode with interrupts enabled
//	_BIS_SR(LPM1_bits + GIE);

	unsigned char c = 0;
	while (UC0IFG & UCB0TXIFG == 0); // wait while not ready for TX
	UCB0TXBUF = 0xAB; // write
	while (UC0IFG & UCB0RXIFG == 0); // wait for RX buffer (full)
	c = UCB0RXBUF;

	while(1);
}

//#pragma vector=TIMER0_A0_VECTOR
//__interrupt void Timer0_A0(void) {
//	// This vector gets called on timer A comparator 0 interrupt
//	P1OUT ^= BIT0;      // Toggle LED
//	TACCR0 += 32768;    // Add offset to CCR0
//	TACCTL0 &= ~CCIFG;  // Reset the interrupt flag
//}

//#pragma vector=TIMER0_A1_VECTOR
//__interrupt void Timer0_A1(void) {
//	// This vector gets called on timer A overflow and comparators 1 and 2
//	P1OUT ^= BIT6;      // Toggle LED
//	TACTL &= ~TAIFG;    // Reset the interrupt flag
//}
