#include <msp430.h> 
#include "defines.h"
#include "spi.h"

int main(void) {
    WDTCTL = WDTPW | WDTHOLD;	// Stop watchdog timer

    /* --- Set Oscillator Settings (8Mhz) --------------- */
    // Set DCO to 5, MOD to 0
    DCOCTL = DCO2 | DCO0;
    // Set RSEL to 13
	BCSCTL1 = RSEL3 | RSEL2 | RSEL0;
	// MCLK = DCO/1, SMCLK = MCLK/8
	BCSCTL2 = SELM_0 | DIVM_0 | DIVS_3;
	// LFXT1 = VLOCLK, 1pF termination
	BCSCTL3 = LFXT1S_2 | XCAP_0;
	// Disable oscillator fault interrupt
	IE1 &= ~OFIE;
	/* -------------------------------------------------- */

	/* --- Set Port Settings ---------------------------- */
	// Set ports 1.5/1.6 as outputs
	// Set remaining ports as inputs
	P1DIR = BIT5 | BIT6;
	P2DIR = 0x00;
	// Enable pull-down resistors
	P1REN = ~(BIT5 | BIT6);
	P2REN = 0xFF;
	// Set initial port values
	P1OUT = 0x00;
	P2OUT = 0x00;
	/* -------------------------------------------------- */

	/* --- Set USI Settings (SPI) ----------------------- */
	// Enable SDA/SCL/SCLK ports, MSB->LSB, master mode, output enabled
	USICTL0 = USIPE7 | USIPE6 | USIPE5 | USIMST | USIOE;
	// I2C disabled, counter interrupt enabled
	USICTL1 = USIIE;
	// SMCLK/1, SMCLK source, idle low
	USICKCTL = USIDIV_0 | USISSEL_2;
	// Enable USI module (clear reset bit)
	USICTL0 &= ~USISWRST;
	/* -------------------------------------------------- */

	// Write 0 to the counter to trigger the USI interrupt
//	USICNT = 0;

	// Go into low power mode with interrupts enabled
	_BIS_SR(LPM0_bits + GIE);
}

#pragma vector=USI_VECTOR
__interrupt void USI_SPI_Vector(void) {
	char value = USISR;
	USISR = 0xAB;
	USICNT = 8;
}
