package org.vt.ece4564.latmb;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.CompoundButton.OnCheckedChangeListener;
import android.widget.EditText;
import android.widget.Toast;

public class LATMBActivity extends Activity implements OnClickListener {
	private EditText server_;
	private EditText port_;
	private EditText username_;
	private EditText chatroom_;
	private CheckBox checkGPS_;
	private EditText radius_;
	private Button connect_;
	
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
	    MenuInflater inflater = getMenuInflater();
	    inflater.inflate(R.menu.mainmenu, menu);
	    return true;
	}
	
	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
	    // Handle item selection
	    switch (item.getItemId()) {
	    case R.id.menuMainPreference:
	    	startActivity(new Intent(this, PreferenceActivity.class));
	        return true;
	    default:
	        return super.onOptionsItemSelected(item);
	    }
	}
	
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        server_ = (EditText) findViewById(R.id.editServer);
        port_ = (EditText) findViewById(R.id.editPort);
        username_ = (EditText) findViewById(R.id.editUser);
        chatroom_ = (EditText) findViewById(R.id.editChatroom);
        checkGPS_ = (CheckBox) findViewById(R.id.checkGPS);
        connect_ = (Button) findViewById(R.id.buttonConnect);
        radius_ = (EditText) findViewById(R.id.editRadius);
        radius_.setEnabled(false);
        
        connect_.setOnClickListener(this);
        
        // Disable fields depending on if use GPS is checked or not
        checkGPS_.setOnCheckedChangeListener(new OnCheckedChangeListener() {
			
			@Override
			public void onCheckedChanged(CompoundButton arg0, boolean arg1) {
				if (checkGPS_.isChecked()) {
					radius_.setEnabled(true);
					chatroom_.setEnabled(false);
				} else {
					radius_.setEnabled(false);
					chatroom_.setEnabled(true);
				}
			}
		});
    }

    @Override
    public void onResume() {
    	super.onResume();
    	
    	// Pull the shared preferences and set fields to saved values
    	SharedPreferences sharedPrefs = PreferenceManager.getDefaultSharedPreferences(this);
        server_.setText(sharedPrefs.getString("pref_Default_IP", ""));
        port_.setText(sharedPrefs.getString("pref_Default_Port", ""));
        username_.setText(sharedPrefs.getString("pref_Default_Username", ""));
        chatroom_.setText(sharedPrefs.getString("pref_Default_Chatroom", ""));
        if (sharedPrefs.getBoolean("pref_Use_GPS", false)) {
        	checkGPS_.setChecked(true);
        }
        radius_.setText(sharedPrefs.getString("pref_Search_Radius", "1"));
    }
    
	@Override
	public void onClick(View arg0) {
		// Check to make sure that all required fields are filled out
		if (server_.getText().toString().isEmpty() || port_.getText().toString().isEmpty()) {
			Toast.makeText(this, "The server IP and port must be specified to continue", Toast.LENGTH_SHORT).show();
		} else if (chatroom_.getText().toString().isEmpty() && !checkGPS_.isChecked()) {
			Toast.makeText(this, "A chatroom must be specified or use GPS must be selected", Toast.LENGTH_SHORT).show();
		} else {
			// If everything is ok, start the next intent
			Intent i = new Intent(this, MessageBoardActivity.class);
			i.putExtra("server", server_.getText().toString());
			i.putExtra("port", port_.getText().toString());
			i.putExtra("username", username_.getText().toString());
			i.putExtra("chatroom", chatroom_.getText().toString());
			i.putExtra("radius", Double.parseDouble(radius_.getText().toString()));
			i.putExtra("gps", checkGPS_.isChecked());
			
			startActivity(i);
		}
	}
}