package IEEERobotics.IOIOAI.VT;

import android.content.SharedPreferences;
import android.content.SharedPreferences.OnSharedPreferenceChangeListener;
import android.os.Bundle;
import android.preference.CheckBoxPreference;
import android.preference.EditTextPreference;
import android.preference.PreferenceManager;
import android.text.InputType;

public class GlobalPreferenceActivity extends android.preference.PreferenceActivity implements OnSharedPreferenceChangeListener {
	
	private CheckBoxPreference _pref_startDebug;
	private EditTextPreference _pref_graphLength;
	private EditTextPreference _pref_updateInterval;
	
	private SharedPreferences sharedPrefs;
	
	@Override
	public void onCreate(Bundle savedInstanceState) {    
	    super.onCreate(savedInstanceState);       
	    addPreferencesFromResource(R.xml.settings);
	    
	    _pref_startDebug = (CheckBoxPreference) findPreference("pref_StartInDebug");
	    _pref_graphLength = (EditTextPreference) findPreference("pref_GraphLength");
	    _pref_updateInterval = (EditTextPreference) findPreference("pref_UpdateInterval");
	    
	    sharedPrefs = PreferenceManager.getDefaultSharedPreferences(this);
	}

	@Override
	public void onResume() {
		super.onResume();
		
		// Set the summary text to the current values when the preferences page is opened
		if (sharedPrefs.getBoolean("pref_StartInDebug", true))
			_pref_startDebug.setSummary("Currently starting in Debug Mode");
		else
			_pref_startDebug.setSummary("Currently starting in AI Mode");
		
		_pref_graphLength.setSummary("Current Value: " + sharedPrefs.getString("pref_GraphLength", ""));
		_pref_graphLength.getEditText().setInputType(InputType.TYPE_CLASS_NUMBER);
		
		_pref_updateInterval.setSummary("Current Value: " + sharedPrefs.getString("pref_UpdateInterval", "") + "ms");
		_pref_updateInterval.getEditText().setInputType(InputType.TYPE_CLASS_NUMBER);
		
		getPreferenceScreen().getSharedPreferences().registerOnSharedPreferenceChangeListener(this);
	}
	
	@Override
	public void onPause() {
		super.onPause();
		getPreferenceScreen().getSharedPreferences().unregisterOnSharedPreferenceChangeListener(this);
	}
	
	@Override
	public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
		// Change the summary text when the value is changed
		if (key.compareTo("pref_StartInDebug") == 0) {
			if (sharedPrefs.getBoolean("pref_StartInDebug", true))
				_pref_startDebug.setSummary("Currently starting in Debug Mode");
			else
				_pref_startDebug.setSummary("Currently starting in AI Mode");
		} else if (key.compareTo("pref_GraphLength") == 0) {
			_pref_graphLength.setSummary("Current Value: " + sharedPrefs.getString("pref_GraphLength", "100"));
		} else if (key.compareTo("pref_UpdateInterval") == 0) {
			_pref_updateInterval.setSummary("Current Value: " + sharedPrefs.getString("pref_UpdateInterval", "100") + "ms");
		}
	}
}
