package IEEERobotics.IOIOAI.VT;

import ioio.lib.api.AnalogInput;
import ioio.lib.api.DigitalOutput;
import ioio.lib.api.IOIO;
import ioio.lib.api.exception.ConnectionLostException;

public class InputCapacitance implements InputInterface {
	IOIO _ioio;
	private static int VOUT_PIN = 44;
	private static int VIN_PIN = 45;
	private AnalogInput _vin;
	private DigitalOutput _vout;
	
	@Override
	public void initialize(IOIO ioio) throws ConnectionLostException {
		_ioio = ioio;
		_vin = ioio.openAnalogInput(VIN_PIN);
		_vout = ioio.openDigitalOutput(VOUT_PIN);
	}

	@Override
	public double getValue() throws InterruptedException, ConnectionLostException {
		// Applies voltage to capacitor for 1 ms
    	_vout.write(true);
    	Thread.sleep(1);
    	_vout.write(false);

    	// Get voltage of capacitor
    	float vc = _vin.getVoltage();
    	
    	return vc;
	}

	@Override
	public String getPinDescription() {
		return "Pin #44-45";
	}

	@Override
	public void closePins() {
		_vin.close();
		_vout.close();
	}

}
