package IEEERobotics.IOIOAI.VT;

import ioio.lib.api.AnalogInput;
import ioio.lib.api.IOIO;
import ioio.lib.api.exception.ConnectionLostException;

public class InputVoltage implements InputInterface {
	IOIO _ioio;
	private static int VNEG_PIN = 42;
	private static int VPOS_PIN = 43;
	private AnalogInput _negvolt;
	private AnalogInput _posvolt;
	
	@Override
	public void initialize(IOIO ioio) throws ConnectionLostException {
		_ioio = ioio;
		_negvolt = _ioio.openAnalogInput(VNEG_PIN);
		_posvolt = _ioio.openAnalogInput(VPOS_PIN);
	}

	@Override
	public double getValue() throws InterruptedException, ConnectionLostException {
		// Read in voltage
        float volt = _posvolt.getVoltage();
        
        // If volt is zero, check reverse polarity
        if (volt == 0) {
				volt = _negvolt.getVoltage();
        }
        
        return (double)volt;
	}

	@Override
	public String getPinDescription() {
		return "Pin #42-43";
	}

	@Override
	public void closePins() {
		_negvolt.close();
		_posvolt.close();
	}

}
