package IEEERobotics.IOIOAI.VT;

import ioio.lib.api.IOIO;
import ioio.lib.api.exception.ConnectionLostException;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;

public class AICode {
	private IOIORoboticsActivity _parent;
	private IOIO _ioio;
	private Boolean _connected = false;
	
	// Input classes to be implemented
	private InputInterface _lineFollowIn;
	private InputInterface _voltageIn;
	private InputInterface _waveformIn;
	private InputInterface _capacitanceIn;
	private InputInterface _temperatureIn;
	
	// AI thread
	private Thread _pollingThread;
	
	/** Class initializer */
	public AICode(IOIORoboticsActivity parent) {
		_parent = parent;
	}
	
	/** Starting poing for executing AI code */
	public void Run() {
		// Initialize the input classes
		initializeInputs();
		
		setupPollingThread();
		
		_pollingThread.start();
	}
	
	/** Initialize input classes */
	private void initializeInputs() {
		_parent.logMessage("Initializing inputs");
		
		_ioio = IOIORoboticsActivity.IOIOInstance_;
		
		// Initialize each input class (opens pins)
		try {
			_lineFollowIn = new InputLineFollower();
			_lineFollowIn.initialize(_ioio);
			
			_voltageIn = new InputVoltage();
			_voltageIn.initialize(_ioio);
			
			_waveformIn = new InputWaveform();
			_waveformIn.initialize(_ioio);
			
			_capacitanceIn = new InputCapacitance();
			_capacitanceIn.initialize(_ioio);
			
			_temperatureIn = new InputTemperature();
			_temperatureIn.initialize(_ioio);
			
			_connected = true;
		} catch (ConnectionLostException e) {
			
		}
	}
	
	/** Sets up the AI thread to poll for data */
	private void setupPollingThread() {
		_pollingThread = new Thread (new Runnable() {
			@Override
			public void run() {
				
				/////////////////////////////
				//   INSERT AI CODE HERE   //
				/////////////////////////////
				
			}
		});
	}
	
	/** Sends an interrupt signal to the thread and notifies input classes to close pins */
	public void stopPollingThread() {
		if (_pollingThread.isAlive()) {
			_parent.logMessage("Stopping polling thread");
			_pollingThread.interrupt();
		}
		
		if (_connected) {
			_lineFollowIn.closePins();
			_voltageIn.closePins();
			_waveformIn.closePins();
			_capacitanceIn.closePins();
			_temperatureIn.closePins();
		}
		
		_connected = false;
	}
}
