/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.ui;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.Region;
import android.view.MotionEvent;
import android.view.View;
import com.androidplot.exception.PlotRenderException;
import com.androidplot.ui.AnchorPosition;
import com.androidplot.ui.PositionMetrics;
import com.androidplot.ui.widget.Widget;
import com.androidplot.util.PixelUtils;
import com.androidplot.util.ZHash;
import com.androidplot.xy.XLayoutStyle;
import com.androidplot.xy.YLayoutStyle;

public class LayoutManager
extends ZHash<Widget, PositionMetrics>
implements View.OnTouchListener {
    private boolean a = true;
    private Paint b = new Paint();
    private boolean c = true;
    private Paint d;
    private boolean e = true;
    private Paint f;
    private boolean g = true;
    private Paint h;
    private boolean i = true;
    private Paint j;

    public LayoutManager() {
        this.b.setStyle(Paint.Style.FILL);
        this.b.setColor(-16711936);
        this.d = new Paint();
        this.d.setColor(-16711936);
        this.d.setStyle(Paint.Style.STROKE);
        this.f = new Paint();
        this.f.setColor(-12303292);
        this.f.setStyle(Paint.Style.FILL);
        this.f.setShadowLayer(3.0f, 5.0f, 5.0f, -16777216);
        this.h = new Paint();
        this.h.setColor(-256);
        this.h.setStyle(Paint.Style.FILL);
        this.h.setAlpha(200);
        this.j = new Paint();
        this.j.setColor(-16776961);
        this.j.setStyle(Paint.Style.FILL);
        this.j.setAlpha(200);
    }

    public void disableAllMarkup() {
        this.setDrawOutlinesEnabled(false);
        this.setDrawAnchorsEnabled(false);
        this.setDrawMarginsEnabled(false);
        this.setDrawPaddingEnabled(false);
        this.setDrawOutlineShadowsEnabled(false);
    }

    public AnchorPosition getElementAnchor(Widget widget) {
        return ((PositionMetrics)this.get(widget)).getAnchor();
    }

    public boolean setElementAnchor(Widget widget, AnchorPosition anchorPosition) {
        if ((this = (PositionMetrics)((ZHash)this).get(widget)) == null) {
            return false;
        }
        ((PositionMetrics)this).setAnchor(anchorPosition);
        return true;
    }

    public static PointF getAnchorCoordinates(RectF rectF, AnchorPosition anchorPosition) {
        return PixelUtils.add(new PointF(rectF.left, rectF.top), LayoutManager.getAnchorOffset(rectF.width(), rectF.height(), anchorPosition));
    }

    public static PointF getAnchorCoordinates(float f, float f2, float f3, float f4, AnchorPosition anchorPosition) {
        return LayoutManager.getAnchorCoordinates(new RectF(f, f2, f + f3, f2 + f4), anchorPosition);
    }

    public static PointF getAnchorOffset(float f, float f2, AnchorPosition anchorPosition) {
        PointF pointF = new PointF();
        switch (anchorPosition) {
            case LEFT_TOP: {
                break;
            }
            case LEFT_MIDDLE: {
                pointF.set(0.0f, f2 / 2.0f);
                break;
            }
            case LEFT_BOTTOM: {
                pointF.set(0.0f, f2);
                break;
            }
            case RIGHT_TOP: {
                pointF.set(f, 0.0f);
                break;
            }
            case RIGHT_BOTTOM: {
                pointF.set(f, f2);
                break;
            }
            case RIGHT_MIDDLE: {
                pointF.set(f, f2 / 2.0f);
                break;
            }
            case TOP_MIDDLE: {
                pointF.set(f / 2.0f, 0.0f);
                break;
            }
            case BOTTOM_MIDDLE: {
                pointF.set(f / 2.0f, f2);
                break;
            }
            case CENTER: {
                pointF.set(f / 2.0f, f2 / 2.0f);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported anchor location: " + (Object)((Object)anchorPosition));
            }
        }
        return pointF;
    }

    public PointF getElementCoordinates(float f, float f2, RectF rectF, PositionMetrics positionMetrics) {
        float f3 = positionMetrics.getxPositionMetric().getPixelValue(rectF.width()) + rectF.left;
        float f4 = positionMetrics.getyPositionMetric().getPixelValue(rectF.height()) + rectF.top;
        PointF pointF = new PointF(f3, f4);
        return PixelUtils.sub(pointF, LayoutManager.getAnchorOffset(f2, f, positionMetrics.getAnchor()));
    }

    public synchronized void draw(Canvas canvas, RectF object, RectF object22, RectF rectF) throws PlotRenderException {
        if (this.isDrawMarginsEnabled()) {
            LayoutManager.a(canvas, (RectF)object, (RectF)object22, this.h);
        }
        if (this.isDrawPaddingEnabled()) {
            LayoutManager.a(canvas, (RectF)object22, rectF, this.j);
        }
        for (Object object22 : this.getKeysAsList()) {
            try {
                canvas.save(31);
                PositionMetrics positionMetrics = (PositionMetrics)this.get(object22);
                float f = ((Widget)object22).getWidthPix(rectF.width());
                float f2 = ((Widget)object22).getHeightPix(rectF.height());
                PointF pointF = this.getElementCoordinates(f2, f, rectF, positionMetrics);
                RectF rectF2 = new RectF(pointF.x, pointF.y, pointF.x + f, pointF.y + f2);
                if (this.e) {
                    canvas.drawRect(rectF2, this.f);
                }
                if (((Widget)object22).isClippingEnabled()) {
                    canvas.clipRect(rectF2, Region.Op.INTERSECT);
                }
                ((Widget)object22).draw(canvas, rectF2);
                RectF rectF3 = ((Widget)object22).getMarginatedRect(rectF2);
                object22 = ((Widget)object22).getPaddedRect(rectF3);
                if (this.g) {
                    LayoutManager.a(canvas, rectF2, rectF3, this.getMarginPaint());
                }
                if (this.i) {
                    LayoutManager.a(canvas, rectF3, (RectF)object22, this.getPaddingPaint());
                }
                if (this.a) {
                    Object object3 = object22 = LayoutManager.getAnchorCoordinates(pointF.x, pointF.y, f, f2, positionMetrics.getAnchor());
                    positionMetrics = canvas;
                    object22 = this;
                    f2 = 4.0f;
                    positionMetrics.drawRect(((PointF)object3).x - f2, ((PointF)object3).y - f2, ((PointF)object3).x + f2, ((PointF)object3).y + f2, ((LayoutManager)object22).b);
                }
                if (!this.c) continue;
                this.d.setAntiAlias(true);
                canvas.drawRect(rectF2, this.d);
            }
            finally {
                canvas.restore();
            }
        }
    }

    private static void a(Canvas canvas, RectF rectF, RectF rectF2, Paint paint) {
        try {
            canvas.save(31);
            canvas.clipRect(rectF2, Region.Op.DIFFERENCE);
            canvas.drawRect(rectF, paint);
            return;
        }
        finally {
            canvas.restore();
        }
    }

    public void position(Widget widget, float f, XLayoutStyle xLayoutStyle, float f2, YLayoutStyle yLayoutStyle) {
        this.position(widget, f, xLayoutStyle, f2, yLayoutStyle, AnchorPosition.LEFT_TOP);
    }

    public void position(Widget widget, float f, XLayoutStyle xLayoutStyle, float f2, YLayoutStyle yLayoutStyle, AnchorPosition anchorPosition) {
        this.addToTop(widget, new PositionMetrics(f, xLayoutStyle, f2, yLayoutStyle, anchorPosition));
    }

    public boolean isDrawOutlinesEnabled() {
        return this.c;
    }

    public void setDrawOutlinesEnabled(boolean bl) {
        this.c = bl;
    }

    public Paint getOutlinePaint() {
        return this.d;
    }

    public void setOutlinePaint(Paint paint) {
        this.d = paint;
    }

    public boolean isDrawAnchorsEnabled() {
        return this.a;
    }

    public void setDrawAnchorsEnabled(boolean bl) {
        this.a = bl;
    }

    public boolean isDrawMarginsEnabled() {
        return this.g;
    }

    public void setDrawMarginsEnabled(boolean bl) {
        this.g = bl;
    }

    public Paint getMarginPaint() {
        return this.h;
    }

    public void setMarginPaint(Paint paint) {
        this.h = paint;
    }

    public boolean isDrawPaddingEnabled() {
        return this.i;
    }

    public void setDrawPaddingEnabled(boolean bl) {
        this.i = bl;
    }

    public Paint getPaddingPaint() {
        return this.j;
    }

    public void setPaddingPaint(Paint paint) {
        this.j = paint;
    }

    public boolean isDrawOutlineShadowsEnabled() {
        return this.e;
    }

    public void setDrawOutlineShadowsEnabled(boolean bl) {
        this.e = bl;
    }

    public Paint getOutlineShadowPaint() {
        return this.f;
    }

    public void setOutlineShadowPaint(Paint paint) {
        this.f = paint;
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        return false;
    }
}

