package IEEERobotics.IOIOAI.VT;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.preference.PreferenceManager;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TableRow.LayoutParams;
import ioio.lib.api.IOIO;
import ioio.lib.api.PwmOutput;
import ioio.lib.api.exception.ConnectionLostException;

public class MotorControl implements OnClickListener{
	private IOIORoboticsActivity _parent;
	private IOIO _ioio;
	private Context _appContext;
	private SharedPreferences _sharedPrefs;
	private View _debugView;
	
	private Button _forward;
	private Button _back;
	private Button _left;
	private Button _right;
	
	private PwmOutput leftPWM;
	private PwmOutput rightPWM;
	
	private static int MOTOR_LEFT = 12;
	private static int MOTOR_RIGHT = 13;
	
	private static int TEXT_SIZE = 20;
	private static int SENSITIVITY = 120;
	
	public MotorControl(IOIORoboticsActivity parent) {
		_parent = parent;
		_ioio = IOIORoboticsActivity.IOIOInstance_;
		_appContext = IOIORoboticsActivity.context_;
		_sharedPrefs = PreferenceManager.getDefaultSharedPreferences(_appContext);
		
		createDebugView();
		initializeOutputs();
	}
	
	public void setSensitivity(int sensitivity) {
		SENSITIVITY = sensitivity;
	}

	public void setMotorSpeed() {
		
	}
	
	private void initializeOutputs() {
		try {
			leftPWM = _ioio.openPwmOutput(MOTOR_LEFT, SENSITIVITY);
			rightPWM = _ioio.openPwmOutput(MOTOR_RIGHT, SENSITIVITY);
		} catch (ConnectionLostException e) {
			
		}
	}
	
	public void disconnect() {
		leftPWM.close();
		rightPWM.close();
	}
	
	@Override
	public void onClick(View v) {
		Button btn = (Button)v;
		if (btn == _forward) {
			_parent.logMessage("Front");
		} else if (btn == _back) {
			_parent.logMessage("Back");
		} else if (btn == _left) {
			_parent.logMessage("Left");
		} else if (btn == _right) {
			_parent.logMessage("Right");
		}
	}
	
	private void createDebugView() {
		_forward = new Button(_appContext);
		_forward.setText("Forwards");
		_forward.setLayoutParams(new LayoutParams(LayoutParams.FILL_PARENT, LayoutParams.FILL_PARENT, (float)0.3));
		_forward.setBackgroundColor(Color.BLACK);
		_forward.setTextColor(Color.WHITE);
		_forward.setTextSize(TEXT_SIZE);
		_forward.setOnClickListener(this);
		
		_back = new Button(_appContext);
		_back.setText("Backwards");
		_back.setLayoutParams(new LayoutParams(LayoutParams.FILL_PARENT, LayoutParams.FILL_PARENT, (float)0.3));
		_back.setBackgroundColor(Color.BLACK);
		_back.setTextColor(Color.WHITE);
		_back.setTextSize(TEXT_SIZE);
		_back.setOnClickListener(this);
		
		_left = new Button(_appContext);
		_left.setText("Left");
		_left.setLayoutParams(new LayoutParams(LayoutParams.FILL_PARENT, LayoutParams.FILL_PARENT, (float)0.5));
		_left.setBackgroundColor(Color.BLACK);
		_left.setTextColor(Color.WHITE);
		_left.setTextSize(TEXT_SIZE);
		_left.setOnClickListener(this);
		
		_right = new Button(_appContext);
		_right.setText("Right");
		_right.setLayoutParams(new LayoutParams(LayoutParams.FILL_PARENT, LayoutParams.FILL_PARENT, (float)0.5));
		_right.setBackgroundColor(Color.BLACK);
		_right.setTextColor(Color.WHITE);
		_right.setTextSize(TEXT_SIZE);
		_right.setOnClickListener(this);
		
		LinearLayout center = new LinearLayout(_appContext);
		center.setOrientation(LinearLayout.HORIZONTAL);
		center.setLayoutParams(new LayoutParams(LayoutParams.FILL_PARENT, LayoutParams.FILL_PARENT, (float)0.25));
		center.addView(_left);
		center.addView(_right);
		
		LinearLayout root = new LinearLayout(_appContext);
		root.setOrientation(LinearLayout.VERTICAL);
		root.setLayoutParams(new LayoutParams(LayoutParams.FILL_PARENT, LayoutParams.FILL_PARENT, (float)1.0));
		root.addView(_forward);
		root.addView(center);
		root.addView(_back);
		
		_debugView = root;
	}
	
	public View getDebugView() {
		return _debugView;
	}
}
