/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.xy;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.PointF;
import android.util.AttributeSet;
import com.androidplot.Plot;
import com.androidplot.series.XYSeries;
import com.androidplot.ui.AnchorPosition;
import com.androidplot.ui.DynamicTableModel;
import com.androidplot.ui.SizeLayoutType;
import com.androidplot.ui.SizeMetrics;
import com.androidplot.ui.TextOrientationType;
import com.androidplot.ui.widget.DomainLabelWidget;
import com.androidplot.ui.widget.RangeLabelWidget;
import com.androidplot.util.PixelUtils;
import com.androidplot.xy.BarFormatter;
import com.androidplot.xy.BarRenderer;
import com.androidplot.xy.BezierLineAndPointFormatter;
import com.androidplot.xy.BezierLineAndPointRenderer;
import com.androidplot.xy.BoundaryMode;
import com.androidplot.xy.LineAndPointFormatter;
import com.androidplot.xy.LineAndPointRenderer;
import com.androidplot.xy.RectRegion;
import com.androidplot.xy.StepFormatter;
import com.androidplot.xy.StepRenderer;
import com.androidplot.xy.XLayoutStyle;
import com.androidplot.xy.XValueMarker;
import com.androidplot.xy.XYFramingModel;
import com.androidplot.xy.XYGraphWidget;
import com.androidplot.xy.XYLegendWidget;
import com.androidplot.xy.XYSeriesFormatter;
import com.androidplot.xy.XYSeriesRenderer;
import com.androidplot.xy.XYStepMode;
import com.androidplot.xy.YLayoutStyle;
import com.androidplot.xy.YValueMarker;
import java.text.Format;
import java.util.ArrayList;

public class XYPlot
extends Plot<XYSeries, XYSeriesFormatter, XYSeriesRenderer> {
    private BoundaryMode c;
    private BoundaryMode d;
    private XYLegendWidget e;
    private XYGraphWidget f;
    private DomainLabelWidget g;
    private RangeLabelWidget h;
    private XYStepMode i = XYStepMode.SUBDIVIDE;
    private double j = 10.0;
    private XYStepMode k = XYStepMode.SUBDIVIDE;
    private double l = 10.0;
    private String m = "domain";
    private String n = "range";
    private Number o;
    private Number p;
    private Number q;
    private Number r;
    private Number s;
    private Number t;
    private Number u;
    private Number v;
    private Number w;
    private Number x;
    private Number y;
    private Number z;
    private XYFramingModel A = XYFramingModel.EDGE;
    private XYFramingModel B = XYFramingModel.EDGE;
    private Number C;
    private Number D;
    private Number E;
    private Number F;
    private Number G = null;
    private Number H = null;
    private BoundaryMode I = BoundaryMode.AUTO;
    private BoundaryMode J = BoundaryMode.AUTO;
    private BoundaryMode K = BoundaryMode.AUTO;
    private BoundaryMode L = BoundaryMode.AUTO;
    private boolean M = true;
    private boolean N = true;
    ArrayList<YValueMarker> a;
    ArrayList<XValueMarker> b;
    private RectRegion O;

    public XYPlot(Context context, String string) {
        super(context, string);
        this.a(context);
    }

    public XYPlot(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.a(context);
    }

    public XYPlot(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.a(context);
    }

    private void a(Context context) {
        this.e = new XYLegendWidget(this, new SizeMetrics(PixelUtils.dpToPix(context, 10.0f), SizeLayoutType.ABSOLUTE, 0.5f, SizeLayoutType.RELATIVE), new DynamicTableModel(0, 1), new SizeMetrics(PixelUtils.dpToPix(context, 7.0f), SizeLayoutType.ABSOLUTE, PixelUtils.dpToPix(context, 7.0f), SizeLayoutType.ABSOLUTE));
        this.f = new XYGraphWidget(this, new SizeMetrics(PixelUtils.dpToPix(context, 18.0f), SizeLayoutType.FILL, PixelUtils.dpToPix(context, 10.0f), SizeLayoutType.FILL));
        Paint paint = new Paint();
        paint.setColor(-12303292);
        paint.setStyle(Paint.Style.FILL);
        this.f.setBackgroundPaint(paint);
        this.g = new DomainLabelWidget(this, new SizeMetrics(PixelUtils.dpToPix(context, 10.0f), SizeLayoutType.ABSOLUTE, PixelUtils.dpToPix(context, 80.0f), SizeLayoutType.ABSOLUTE), TextOrientationType.HORIZONTAL);
        this.h = new RangeLabelWidget(this, new SizeMetrics(PixelUtils.dpToPix(context, 50.0f), SizeLayoutType.ABSOLUTE, PixelUtils.dpToPix(context, 10.0f), SizeLayoutType.ABSOLUTE), TextOrientationType.VERTICAL_ASCENDING);
        this.getLayoutManager().position(this.e, PixelUtils.dpToPix(context, 40.0f), XLayoutStyle.ABSOLUTE_FROM_RIGHT, PixelUtils.dpToPix(context, 0.0f), YLayoutStyle.ABSOLUTE_FROM_BOTTOM, AnchorPosition.RIGHT_BOTTOM);
        this.getLayoutManager().position(this.f, PixelUtils.dpToPix(context, 0.0f), XLayoutStyle.ABSOLUTE_FROM_RIGHT, PixelUtils.dpToPix(context, 0.0f), YLayoutStyle.ABSOLUTE_FROM_CENTER, AnchorPosition.RIGHT_MIDDLE);
        this.getLayoutManager().position(this.g, PixelUtils.dpToPix(context, 20.0f), XLayoutStyle.ABSOLUTE_FROM_LEFT, PixelUtils.dpToPix(context, 0.0f), YLayoutStyle.ABSOLUTE_FROM_BOTTOM, AnchorPosition.LEFT_BOTTOM);
        this.getLayoutManager().position(this.h, PixelUtils.dpToPix(context, 0.0f), XLayoutStyle.ABSOLUTE_FROM_LEFT, PixelUtils.dpToPix(context, 0.0f), YLayoutStyle.ABSOLUTE_FROM_CENTER, AnchorPosition.LEFT_MIDDLE);
        this.getLayoutManager().moveToTop(this.getTitleWidget());
        this.getLayoutManager().moveToTop(this.getLegendWidget());
        this.f.setMarginTop(PixelUtils.dpToPix(context, 3.0f));
        this.f.setMarginRight(PixelUtils.dpToPix(context, 3.0f));
        this.getTitleWidget().pack();
        this.getDomainLabelWidget().pack();
        this.getRangeLabelWidget().pack();
        this.setPlotMarginLeft(PixelUtils.dpToPix(context, 2.0f));
        this.setPlotMarginRight(PixelUtils.dpToPix(context, 2.0f));
        this.setPlotMarginBottom(PixelUtils.dpToPix(context, 2.0f));
        this.b = new ArrayList();
        this.a = new ArrayList();
        this.setDefaultBounds(new RectRegion(-1, 1, -1, 1));
    }

    public void setGridPadding(float f, float f2, float f3, float f4) {
        this.getGraphWidget().setGridPaddingTop(f2);
        this.getGraphWidget().setGridPaddingBottom(f4);
        this.getGraphWidget().setGridPaddingLeft(f);
        this.getGraphWidget().setGridPaddingRight(f3);
    }

    @Override
    protected final void a() {
        this.calculateMinMaxVals();
    }

    public boolean containsPoint(float f, float f2) {
        if (this.getGraphWidget().getGridRect() != null) {
            return this.getGraphWidget().getGridRect().contains(f, f2);
        }
        return false;
    }

    public boolean containsPoint(PointF pointF) {
        return this.containsPoint(pointF.x, pointF.y);
    }

    public void setCursorPosition(PointF pointF) {
        this.getGraphWidget().setCursorPosition(pointF);
    }

    public void setCursorPosition(float f, float f2) {
        this.getGraphWidget().setCursorPosition(f, f2);
    }

    public Number getYVal(PointF pointF) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public Number getXVal(PointF pointF) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    private static boolean a(double d, Number number, Number number2) {
        boolean bl;
        boolean bl2 = number == null || d >= number.doubleValue();
        boolean bl3 = bl = number2 == null || d <= number2.doubleValue();
        return bl2 && bl;
    }

    public void calculateMinMaxVals() {
        XYPlot xYPlot;
        this.w = this.s;
        this.x = this.t;
        this.y = this.u;
        this.z = this.v;
        this.s = this.o;
        this.t = this.p;
        this.u = this.q;
        this.v = this.r;
        for (XYSeries xYSeries : this.getSeriesSet()) {
            for (int i = 0; i < xYSeries.size(); ++i) {
                Number number;
                Number number2 = xYSeries.getX(i);
                Number number3 = number = xYSeries.getY(i);
                Number number4 = number2;
                xYPlot = this;
                if (!(number4 == null || number3 == null ? false : XYPlot.a(number3.doubleValue(), xYPlot.q, xYPlot.r) && XYPlot.a(number4.doubleValue(), xYPlot.o, xYPlot.p))) continue;
                if (this.o == null && number2 != null && (this.s == null || number2.doubleValue() < this.s.doubleValue())) {
                    this.s = number2;
                }
                if (this.p == null && number2 != null && (this.t == null || number2.doubleValue() > this.t.doubleValue())) {
                    this.t = number2;
                }
                if (this.q == null && number != null && (this.u == null || number.doubleValue() < this.u.doubleValue())) {
                    this.u = number;
                }
                if (this.r != null || number == null || this.v != null && !(number.doubleValue() > this.v.doubleValue())) continue;
                this.v = number;
            }
        }
        block0 : switch (this.A) {
            case ORIGIN: {
                this.updateDomainMinMaxForOriginModel();
                break;
            }
            case EDGE: {
                xYPlot = this;
                switch (xYPlot.I) {
                    case FIXED: {
                        break;
                    }
                    case AUTO: {
                        break;
                    }
                    case GROW: {
                        if (xYPlot.x == null || xYPlot.t.doubleValue() > xYPlot.x.doubleValue()) break;
                        xYPlot.t = xYPlot.x;
                        break;
                    }
                    case SHRINNK: {
                        if (xYPlot.x == null || xYPlot.t.doubleValue() < xYPlot.x.doubleValue()) break;
                        xYPlot.t = xYPlot.x;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("DomainUpperBoundaryMode not yet implemented: " + (Object)((Object)xYPlot.I));
                    }
                }
                switch (xYPlot.J) {
                    case FIXED: {
                        break block0;
                    }
                    case AUTO: {
                        break block0;
                    }
                    case GROW: {
                        if (xYPlot.w == null || xYPlot.s.doubleValue() < xYPlot.w.doubleValue()) break block0;
                        xYPlot.s = xYPlot.w;
                        break block0;
                    }
                    case SHRINNK: {
                        if (xYPlot.w == null || xYPlot.s.doubleValue() > xYPlot.w.doubleValue()) break block0;
                        xYPlot.s = xYPlot.w;
                        break block0;
                    }
                    default: {
                        throw new UnsupportedOperationException("DomainLowerBoundaryMode not supported: " + (Object)((Object)xYPlot.J));
                    }
                }
            }
            default: {
                throw new UnsupportedOperationException("Domain Framing Model not yet supported: " + (Object)((Object)this.A));
            }
        }
        switch (this.B) {
            case ORIGIN: {
                this.updateRangeMinMaxForOriginModel();
                break;
            }
            case EDGE: {
                this.updateRangeMinMaxForEdgeModel();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Range Framing Model not yet supported: " + (Object)((Object)this.A));
            }
        }
        this.E = this.C != null ? (Number)this.C : (Number)this.getCalculatedMinX();
        this.F = this.D != null ? (Number)this.D : (Number)this.getCalculatedMinY();
    }

    public void updateRangeMinMaxForEdgeModel() {
        switch (this.K) {
            case FIXED: {
                break;
            }
            case AUTO: {
                break;
            }
            case GROW: {
                if (this.z == null || this.v.doubleValue() > this.z.doubleValue()) break;
                this.v = this.z;
                break;
            }
            case SHRINNK: {
                if (this.z == null || this.v.doubleValue() < this.z.doubleValue()) break;
                this.v = this.z;
                break;
            }
            default: {
                throw new UnsupportedOperationException("RangeUpperBoundaryMode not supported: " + (Object)((Object)this.K));
            }
        }
        switch (this.L) {
            case FIXED: {
                return;
            }
            case AUTO: {
                return;
            }
            case GROW: {
                if (this.y == null || this.u.doubleValue() < this.y.doubleValue()) break;
                this.u = this.y;
                return;
            }
            case SHRINNK: {
                if (this.y == null || this.u.doubleValue() > this.y.doubleValue()) break;
                this.u = this.y;
                return;
            }
            default: {
                throw new UnsupportedOperationException("RangeLowerBoundaryMode not supported: " + (Object)((Object)this.L));
            }
        }
    }

    public void centerOnDomainOrigin(Number number) {
        this.centerOnDomainOrigin(number, null, BoundaryMode.AUTO);
    }

    public void centerOnDomainOrigin(Number number, Number number2, BoundaryMode boundaryMode) {
        if (number == null) {
            throw new NullPointerException("Origin param cannot be null.");
        }
        this.A = XYFramingModel.ORIGIN;
        this.setUserDomainOrigin(number);
        this.G = number2;
        this.c = boundaryMode;
        if (this.c == BoundaryMode.FIXED) {
            double d = this.C.doubleValue();
            double d2 = this.G.doubleValue();
            this.p = d + d2;
            this.o = d - d2;
            return;
        }
        this.p = null;
        this.o = null;
    }

    public void centerOnRangeOrigin(Number number) {
        this.centerOnRangeOrigin(number, null, BoundaryMode.AUTO);
    }

    public void centerOnRangeOrigin(Number number, Number number2, BoundaryMode boundaryMode) {
        if (number == null) {
            throw new NullPointerException("Origin param cannot be null.");
        }
        this.B = XYFramingModel.ORIGIN;
        this.setUserRangeOrigin(number);
        this.H = number2;
        this.d = boundaryMode;
        if (this.d == BoundaryMode.FIXED) {
            double d = this.D.doubleValue();
            double d2 = this.H.doubleValue();
            this.r = d + d2;
            this.q = d - d2;
            return;
        }
        this.r = null;
        this.q = null;
    }

    private static double a(double d, double d2) {
        if (d > d2) {
            return d - d2;
        }
        return d2 - d;
    }

    public void updateDomainMinMaxForOriginModel() {
        double d;
        double d2 = this.C.doubleValue();
        double d3 = XYPlot.a(this.t.doubleValue(), d2);
        double d4 = d3 > (d = XYPlot.a(this.s.doubleValue(), d2)) ? d3 : d;
        double d5 = d2 - d4;
        double d6 = d2 + d4;
        switch (this.c) {
            case AUTO: {
                this.s = d5;
                this.t = d6;
                return;
            }
            case FIXED: {
                return;
            }
            case GROW: {
                this.s = this.w == null || d5 < this.w.doubleValue() ? (Number)d5 : (Number)this.w;
                if (this.x == null || d6 > this.x.doubleValue()) {
                    this.t = d6;
                    return;
                }
                this.t = this.x;
                return;
            }
            case SHRINNK: {
                this.s = this.w == null || d5 > this.w.doubleValue() ? (Number)d5 : (Number)this.w;
                if (this.x == null || d6 < this.x.doubleValue()) {
                    this.t = d6;
                    return;
                }
                this.t = this.x;
                return;
            }
        }
        throw new UnsupportedOperationException("Domain Origin Boundary Mode not yet supported: " + (Object)((Object)this.c));
    }

    public void updateRangeMinMaxForOriginModel() {
        switch (this.d) {
            case AUTO: {
                double d = this.D.doubleValue();
                double d2 = XYPlot.a(this.v.doubleValue(), d);
                double d3 = XYPlot.a(this.u.doubleValue(), d);
                if (d2 > d3) {
                    this.u = d - d2;
                    this.v = d + d2;
                    return;
                }
                this.u = d - d3;
                this.v = d + d3;
                return;
            }
        }
        throw new UnsupportedOperationException("Range Origin Boundary Mode not yet supported: " + (Object)((Object)this.d));
    }

    public boolean addSeries(XYSeries xYSeries, XYSeriesFormatter xYSeriesFormatter) {
        Class<LineAndPointRenderer> clazz = xYSeriesFormatter;
        clazz = (clazz = clazz.getClass()) == LineAndPointFormatter.class ? LineAndPointRenderer.class : (clazz == BarFormatter.class ? BarRenderer.class : (clazz == StepFormatter.class ? StepRenderer.class : (clazz == BezierLineAndPointFormatter.class ? BezierLineAndPointRenderer.class : null)));
        return this.addSeries(xYSeries, clazz, xYSeriesFormatter);
    }

    public int getTicksPerRangeLabel() {
        return this.f.getTicksPerRangeLabel();
    }

    public void setTicksPerRangeLabel(int n) {
        this.f.setTicksPerRangeLabel(n);
    }

    public int getTicksPerDomainLabel() {
        return this.f.getTicksPerDomainLabel();
    }

    public void setTicksPerDomainLabel(int n) {
        this.f.setTicksPerDomainLabel(n);
    }

    public XYStepMode getDomainStepMode() {
        return this.i;
    }

    public void setDomainStepMode(XYStepMode xYStepMode) {
        this.i = xYStepMode;
    }

    public double getDomainStepValue() {
        return this.j;
    }

    public void setDomainStepValue(double d) {
        this.j = d;
    }

    public void setDomainStep(XYStepMode xYStepMode, double d) {
        this.setDomainStepMode(xYStepMode);
        this.setDomainStepValue(d);
    }

    public XYStepMode getRangeStepMode() {
        return this.k;
    }

    public void setRangeStepMode(XYStepMode xYStepMode) {
        this.k = xYStepMode;
    }

    public double getRangeStepValue() {
        return this.l;
    }

    public void setRangeStepValue(double d) {
        this.l = d;
    }

    public void setRangeStep(XYStepMode xYStepMode, double d) {
        this.setRangeStepMode(xYStepMode);
        this.setRangeStepValue(d);
    }

    public String getDomainLabel() {
        return this.m;
    }

    public void setDomainLabel(String string) {
        this.m = string;
        if (this.getDomainLabelWidget() != null) {
            this.getDomainLabelWidget().pack();
        }
    }

    public String getRangeLabel() {
        return this.n;
    }

    public void setRangeLabel(String string) {
        this.n = string;
        if (this.getRangeLabelWidget() != null) {
            this.getRangeLabelWidget().pack();
        }
    }

    public XYLegendWidget getLegendWidget() {
        return this.e;
    }

    public void setLegendWidget(XYLegendWidget xYLegendWidget) {
        this.e = xYLegendWidget;
    }

    public XYGraphWidget getGraphWidget() {
        return this.f;
    }

    public void setGraphWidget(XYGraphWidget xYGraphWidget) {
        this.f = xYGraphWidget;
    }

    public DomainLabelWidget getDomainLabelWidget() {
        return this.g;
    }

    public void setDomainLabelWidget(DomainLabelWidget domainLabelWidget) {
        this.g = domainLabelWidget;
    }

    public RangeLabelWidget getRangeLabelWidget() {
        return this.h;
    }

    public void setRangeLabelWidget(RangeLabelWidget rangeLabelWidget) {
        this.h = rangeLabelWidget;
    }

    public Format getRangeValueFormat() {
        return this.f.getRangeValueFormat();
    }

    public void setRangeValueFormat(Format format) {
        this.f.setRangeValueFormat(format);
    }

    public Format getDomainValueFormat() {
        return this.f.getDomainValueFormat();
    }

    public void setDomainValueFormat(Format format) {
        this.f.setDomainValueFormat(format);
    }

    public synchronized void setDomainBoundaries(Number number, Number number2, BoundaryMode boundaryMode) {
        this.setDomainBoundaries(number, boundaryMode, number2, boundaryMode);
    }

    public synchronized void setDomainBoundaries(Number number, BoundaryMode boundaryMode, Number number2, BoundaryMode boundaryMode2) {
        this.setDomainLowerBoundary(number, boundaryMode);
        this.setDomainUpperBoundary(number2, boundaryMode2);
    }

    public synchronized void setRangeBoundaries(Number number, Number number2, BoundaryMode boundaryMode) {
        this.setRangeBoundaries(number, boundaryMode, number2, boundaryMode);
    }

    public synchronized void setRangeBoundaries(Number number, BoundaryMode boundaryMode, Number number2, BoundaryMode boundaryMode2) {
        this.setRangeLowerBoundary(number, boundaryMode);
        this.setRangeUpperBoundary(number2, boundaryMode2);
    }

    public synchronized void setDomainUpperBoundaryMode(BoundaryMode boundaryMode) {
        this.I = boundaryMode;
    }

    public synchronized void setUserMaxX(Number number) {
        if (number == null) {
            throw new NullPointerException("Boundary value cannot be null.");
        }
        this.p = number;
    }

    public synchronized void setDomainUpperBoundary(Number object, BoundaryMode boundaryMode) {
        this.setDomainUpperBoundaryMode(boundaryMode);
        this.setUserMaxX((Number)object);
        object = XYFramingModel.EDGE;
        v0.A = object;
    }

    private synchronized void a(BoundaryMode boundaryMode) {
        this.J = boundaryMode;
    }

    private synchronized void a(Number number) {
        if (number == null) {
            throw new NullPointerException("Boundary value cannot be null.");
        }
        this.o = number;
    }

    public synchronized void setDomainLowerBoundary(Number object, BoundaryMode boundaryMode) {
        this.a(boundaryMode);
        this.a((Number)object);
        object = XYFramingModel.EDGE;
        v0.A = object;
    }

    private synchronized void b(BoundaryMode boundaryMode) {
        this.K = boundaryMode;
    }

    private synchronized void b(Number number) {
        if (number == null) {
            throw new NullPointerException("Boundary value cannot be null.");
        }
        this.r = number;
    }

    public synchronized void setRangeUpperBoundary(Number object, BoundaryMode boundaryMode) {
        this.b(boundaryMode);
        this.b((Number)object);
        object = XYFramingModel.EDGE;
        v0.B = object;
    }

    private synchronized void c(BoundaryMode boundaryMode) {
        this.L = boundaryMode;
    }

    private synchronized void c(Number number) {
        if (number == null) {
            throw new NullPointerException("Boundary value cannot be null.");
        }
        this.q = number;
    }

    public synchronized void setRangeLowerBoundary(Number object, BoundaryMode boundaryMode) {
        this.c(boundaryMode);
        this.c((Number)object);
        object = XYFramingModel.EDGE;
        v0.B = object;
    }

    public Number getDomainOrigin() {
        return this.E;
    }

    public Number getRangeOrigin() {
        return this.F;
    }

    public synchronized void setUserDomainOrigin(Number number) {
        if (number == null) {
            throw new NullPointerException("Origin value cannot be null.");
        }
        this.C = number;
    }

    public synchronized void setUserRangeOrigin(Number number) {
        if (number == null) {
            throw new NullPointerException("Origin value cannot be null.");
        }
        this.D = number;
    }

    public XYFramingModel getDomainFramingModel() {
        return this.A;
    }

    public XYFramingModel getRangeFramingModel() {
        return this.B;
    }

    public Number getCalculatedMinX() {
        if (this.s != null) {
            return this.s;
        }
        return this.getDefaultBounds().getMinX();
    }

    public Number getCalculatedMaxX() {
        if (this.t != null) {
            return this.t;
        }
        return this.getDefaultBounds().getMaxX();
    }

    public Number getCalculatedMinY() {
        if (this.u != null) {
            return this.u;
        }
        return this.getDefaultBounds().getMinY();
    }

    public Number getCalculatedMaxY() {
        if (this.v != null) {
            return this.v;
        }
        return this.getDefaultBounds().getMaxY();
    }

    public boolean isDrawDomainOriginEnabled() {
        return this.M;
    }

    public void setDrawDomainOriginEnabled(boolean bl) {
        this.M = bl;
    }

    public boolean isDrawRangeOriginEnabled() {
        return this.N;
    }

    public void setDrawRangeOriginEnabled(boolean bl) {
        this.N = bl;
    }

    public boolean addMarker(YValueMarker yValueMarker) {
        if (this.a.contains(yValueMarker)) {
            return false;
        }
        return this.a.add(yValueMarker);
    }

    public YValueMarker removeMarker(YValueMarker yValueMarker) {
        int n = this.a.indexOf(yValueMarker);
        if (n == -1) {
            return null;
        }
        return this.a.remove(n);
    }

    public int removeMarkers() {
        int n = this.removeXMarkers();
        return n += this.removeYMarkers();
    }

    public int removeYMarkers() {
        int n = this.a.size();
        this.a.clear();
        return n;
    }

    public boolean addMarker(XValueMarker xValueMarker) {
        return !this.b.contains(xValueMarker) && this.b.add(xValueMarker);
    }

    public XValueMarker removeMarker(XValueMarker xValueMarker) {
        int n = this.b.indexOf(xValueMarker);
        if (n == -1) {
            return null;
        }
        return this.b.remove(n);
    }

    public int removeXMarkers() {
        int n = this.b.size();
        this.b.clear();
        return n;
    }

    public RectRegion getDefaultBounds() {
        return this.O;
    }

    public void setDefaultBounds(RectRegion rectRegion) {
        this.O = rectRegion;
    }
}

