/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.ui.widget;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import com.androidplot.ui.AnchorPosition;
import com.androidplot.ui.LayoutManager;
import com.androidplot.ui.SizeLayoutType;
import com.androidplot.ui.SizeMetrics;
import com.androidplot.ui.TextOrientationType;
import com.androidplot.ui.widget.Widget;
import com.androidplot.util.FontUtils;

public abstract class TextLabelWidget
extends Widget {
    private Paint a = new Paint();
    private TextOrientationType b;

    public TextLabelWidget(SizeMetrics sizeMetrics) {
        this(sizeMetrics, TextOrientationType.HORIZONTAL);
    }

    public TextLabelWidget(SizeMetrics sizeMetrics, TextOrientationType textOrientationType) {
        super(new SizeMetrics(0.0f, SizeLayoutType.ABSOLUTE, 0.0f, SizeLayoutType.ABSOLUTE));
        this.a.setColor(-1);
        this.a.setAntiAlias(true);
        this.a.setTextAlign(Paint.Align.CENTER);
        this.setSize(sizeMetrics);
        this.b = textOrientationType;
    }

    protected abstract String a();

    public void pack() {
        Rect rect = FontUtils.getStringDimensions(this.a(), this.getLabelPaint());
        if (rect == null) {
            return;
        }
        switch (this.b) {
            case HORIZONTAL: {
                this.setSize(new SizeMetrics(rect.height(), SizeLayoutType.ABSOLUTE, rect.width() + 2, SizeLayoutType.ABSOLUTE));
                return;
            }
            case VERTICAL_ASCENDING: 
            case VERTICAL_DESCENDING: {
                this.setSize(new SizeMetrics(rect.width(), SizeLayoutType.ABSOLUTE, rect.height() + 2, SizeLayoutType.ABSOLUTE));
            }
        }
    }

    @Override
    public void doOnDraw(Canvas canvas, RectF rectF) {
        String string = this.a();
        FontUtils.getStringDimensions(string, this.a);
        float f = this.a.getFontMetrics().descent;
        rectF = LayoutManager.getAnchorCoordinates(rectF, AnchorPosition.CENTER);
        try {
            canvas.save(31);
            canvas.translate(rectF.x, rectF.y);
            switch (this.b) {
                case HORIZONTAL: {
                    break;
                }
                case VERTICAL_ASCENDING: {
                    canvas.rotate(-90.0f);
                    break;
                }
                case VERTICAL_DESCENDING: {
                    canvas.rotate(90.0f);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Orientation " + (Object)((Object)this.b) + " not yet implemented for TextLabelWidget.");
                }
            }
            canvas.drawText(string, 0.0f, f, this.a);
            return;
        }
        finally {
            canvas.restore();
        }
    }

    public Paint getLabelPaint() {
        return this.a;
    }

    public void setLabelPaint(Paint paint) {
        this.a = paint;
    }

    public TextOrientationType getOrientation() {
        return this.b;
    }

    public void setOrientation(TextOrientationType textOrientationType) {
        this.b = textOrientationType;
    }
}

