/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.ui;

import android.graphics.Canvas;
import android.graphics.RectF;
import android.graphics.Region;
import com.androidplot.Plot;
import com.androidplot.exception.PlotRenderException;
import com.androidplot.series.Series;
import com.androidplot.series.XYSeries;
import com.androidplot.ui.Formatter;
import com.androidplot.ui.SeriesAndFormatterList;
import com.androidplot.xy.XYRegionFormatter;

public abstract class DataRenderer<PlotType extends Plot, SeriesFormatterType extends Formatter> {
    private PlotType a;

    public DataRenderer(PlotType PlotType) {
        this.a = PlotType;
    }

    public PlotType getPlot() {
        return this.a;
    }

    public void setPlot(PlotType PlotType) {
        this.a = PlotType;
    }

    public SeriesAndFormatterList<XYSeries, SeriesFormatterType> getSeriesAndFormatterList() {
        return ((Plot)((Object)this.a)).getSeriesAndFormatterListForRenderer(this.getClass());
    }

    public SeriesFormatterType getFormatter(Series series) {
        return (SeriesFormatterType)((Formatter)((Plot)((Object)this.a)).getFormatter((Series)series, this.getClass()));
    }

    public void render(Canvas canvas, RectF rectF) throws PlotRenderException {
        this.onRender(canvas, rectF);
    }

    public abstract void onRender(Canvas var1, RectF var2) throws PlotRenderException;

    protected abstract void doDrawLegendIcon(Canvas var1, RectF var2, SeriesFormatterType var3);

    public void drawSeriesLegendIcon(Canvas canvas, RectF rectF, SeriesFormatterType SeriesFormatterType) {
        try {
            canvas.save(31);
            canvas.clipRect(rectF, Region.Op.INTERSECT);
            this.doDrawLegendIcon(canvas, rectF, SeriesFormatterType);
            return;
        }
        finally {
            canvas.restore();
        }
    }

    public void drawRegionLegendIcon(Canvas canvas, RectF rectF, XYRegionFormatter xYRegionFormatter) {
        canvas.drawRect(rectF, xYRegionFormatter.getPaint());
    }
}

