package ioio.debugger.server;

import java.util.List;

public class ServerHelper {

	private IOIODebuggerServerHandler msgHandler;
	
	public ServerHelper(IOIODebuggerServerHandler handler) {
		msgHandler = handler;
	}
	
	public boolean checkClientsConnected() {
		return msgHandler.areClientsConnected();
	}
	
	public void AddNewAnalogIn(int pin, long freq) {
		// Implement this
		System.out.println("Command recieved to add new Analog In. Pin: " + pin + " Freq: " + freq);
	}
	
	public void AddNewDigitalIn(int pin, long freq, String mode) {
		// Implement this
		System.out.println("Command recieved to add new Digital In. Pin: " + pin + " Freq: " + freq + " Mode: " + mode);
	}
	
	public void AddNewDigitalOut(int pin, String state, boolean openDrain) {
		// Implement this
		System.out.println("Command recieved to add new Digital Out. Pin: " + pin + " InitialState: " + state + " OpenDrain: " + openDrain);
	}
	
	public void DataRecieved(int pin, List<Double> data) {
		// Implement this
		System.out.print("Data Recieved from pin: " + pin + " Data: ");
		for (Double d : data)
			System.out.print(d + " ");
		System.out.print("\n");
	}
	
	public void StopPin(int pin) {
		// Implement this
		System.out.println("Command recieved to stop Pin: " + pin);
	}
	
	public void RemovePin(int pin) {
		// Implement this
		System.out.println("Command recieved to remove Pin: " + pin);
	}
	
	public void sendAddNewAnalogIn(int pin, long freq) {
		msgHandler.sendAddNewAnalogIn(pin, freq);
	}
	
	public void sendAddNewDigitalIn(int pin, long freq, String mode) {
		msgHandler.sendAddNewDigitalIn(pin, freq, mode);
	}
	
	public void sendAddNewDigitalOut(int pin, String state, boolean openDrain) {
		msgHandler.sendAddNewDigitalOut(pin, state, openDrain);
	}
	
	public void sendHardReset() {
		msgHandler.sendHardReset();
	}
}
