package ioio.debugger.server;

import java.net.InetSocketAddress;
import java.util.concurrent.Executors;

import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;

public class IOIODebuggerServer {

	private ServerBootstrap bootstrap;
	private IOIODebuggerServerPipelineFactory pipeline;
	
	public IOIODebuggerServer(int port) {
		pipeline = new IOIODebuggerServerPipelineFactory();
		
		// Configure the server.
        bootstrap = new ServerBootstrap(
                new NioServerSocketChannelFactory(
                        Executors.newCachedThreadPool(),
                        Executors.newCachedThreadPool()));

        // Configure the pipeline factory.
        bootstrap.setPipelineFactory(pipeline);

        // Bind and start to accept incoming connections.
        bootstrap.bind(new InetSocketAddress(port));
	}
	
	public IOIODebuggerServerPipelineFactory getPipeline() {
		return pipeline;
	}
}
