package ioio.debugger;

import java.util.LinkedList;

import com.androidplot.Plot.BorderStyle;
import com.androidplot.xy.BoundaryMode;
import com.androidplot.xy.LineAndPointFormatter;
import com.androidplot.xy.StepFormatter;
import com.androidplot.xy.XYPlot;
import com.androidplot.xy.XYStepMode;

import android.graphics.Color;
import android.os.Handler;
import android.view.View;
import android.widget.TextView;

public class ViewWidgetGraphText implements ViewWidget {

	private View view;
	private Runnable run;
	private Thread thread;
	private Handler handler = new Handler();
	private GenericXYSeries plotData;
	private XYPlot historyPlot;
	private int pin;

	public ViewWidgetGraphText() {
		
	}
	
	@Override
	public void stopThread() {
		thread.interrupt();
	}
	
	@Override
	public void startThread() {
		// Kill the thread if it is already running
		if (thread != null && thread.isAlive())
			thread.interrupt();
		// Start a new thread and run the passed Runnable
		thread = new Thread (run);
		thread.start();
	}
	
	@Override
	public View getView() {
		return view;
	}

	@Override
	public Thread getThread() {
		return thread;
	}
	
	@Override
	public void clearData() {
		plotData.clearData();
	}
	
	@Override
	public void setStopSignal() {
		handler.post(new Runnable() {
			
			@Override
			public void run() {
				TextView tv = (TextView)view.findViewById(R.id.layout_graphText_status);
				tv.setTextColor(Color.RED);
			}
		});
	}
	
	@Override
	public void resetStopSignal() {
		handler.post(new Runnable() {
			
			@Override
			public void run() {
				TextView tv = (TextView)view.findViewById(R.id.layout_graphText_status);
				tv.setTextColor(Color.WHITE);
			}
		});
	}
	
	@Override
	public void sendDataHistory() {
		LinkedList<Number> data = plotData.getData();
		Double[] data2 = data.toArray(new Double[data.size()]);
		IOIODebuggerActivity.get_networkMgr().sendData(pin, data2);
	}
	
	@Override
	public int getPin() {
		return pin;
	}
	
	public void setPin(final int p) {
		pin = p;
	}
	
	public void updateText(final String str) {
		handler.post(new Runnable() {
			
			@Override
			public void run() {
				TextView tv = (TextView)view.findViewById(R.id.layout_graphText_text);
				tv.setText(str);
			}
		});
	}
	
	public void updateStatus(final String str) {
		handler.post(new Runnable() {
			
			@Override
			public void run() {
				TextView tv = (TextView)view.findViewById(R.id.layout_graphText_status);
				tv.setText(str);
			}
		});
	}

	public void setView(View view, boolean useStep, int historyLength) {
		this.view = view;
		
		// Set graph plot details
		plotData = new GenericXYSeries("Analog In", historyLength);
		historyPlot = (XYPlot) view.findViewById(R.id.layout_graphText_graph);
		
		// Add data to plot
		if (!useStep)
			historyPlot.addSeries(plotData, new LineAndPointFormatter(Color.rgb(0, 0, 200), Color.rgb(0, 0, 100),Color.rgb(150, 150, 190)));
		else {
			StepFormatter stepFormatter = new StepFormatter(Color.rgb(0, 0, 0), Color.rgb(150, 190, 150));
			stepFormatter.getLinePaint().setStrokeWidth(1);
			historyPlot.addSeries(plotData, stepFormatter);
		}
		// Set boundary and ticks
		historyPlot.setRangeBoundaries(0, 3.3, BoundaryMode.FIXED);
		historyPlot.setDomainBoundaries(0, historyLength, BoundaryMode.FIXED);
		historyPlot.setDomainStepValue(5);
		historyPlot.setRangeStep(XYStepMode.SUBDIVIDE, 4);
		historyPlot.setTicksPerRangeLabel(3);
		
		// Remove labels and legend
		historyPlot.getLegendWidget().setVisible(false);
		historyPlot.getDomainLabelWidget().setVisible(false);
		historyPlot.getRangeLabelWidget().setVisible(false);
		historyPlot.getTitleWidget().setVisible(false);
		
		// Remove extra margin space
		historyPlot.getGraphWidget().setMargins(0, 10, 10, 0);
		historyPlot.getGraphWidget().setRangeLabelWidth(30);
		historyPlot.getGraphWidget().setDomainLabelWidth(15);
		historyPlot.getGraphWidget().setMarginLeft(-5);
		historyPlot.getGraphWidget().setMarginRight(25);
		historyPlot.setPlotMargins(0, 0, 0, 0);
		historyPlot.setPlotPadding(0, 0, 0, 0);

		// Remove background color
		historyPlot.getGraphWidget().setBackgroundPaint(null);
		historyPlot.setBackgroundPaint(null);
		historyPlot.setBorderPaint(null);
		
		historyPlot.setBorderStyle(BorderStyle.SQUARE, null, null);
		historyPlot.disableAllMarkup();
	}
	
	public void setRunnable(Runnable r) {
		run = r;
	}
	
	public void updateData(Number num) {
		plotData.addDataToList(num);
	}
	
	public void refreshGraph() {
		handler.post(new Runnable() {

			@Override
			public void run() {
				historyPlot.redraw();
			}
		});
	}
	
	public void setRange(Number start, Number end) {
		historyPlot.setRangeBoundaries(start, end, BoundaryMode.FIXED);
	}
	
	public void setDomain(Number length) {
		historyPlot.setDomainBoundaries(0, length, BoundaryMode.FIXED);
	}
}
