package ioio.debugger;

import android.content.SharedPreferences;
import android.content.SharedPreferences.OnSharedPreferenceChangeListener;
import android.os.Bundle;
import android.preference.EditTextPreference;
import android.preference.PreferenceManager;
import android.text.InputType;

public class GlobalPreferenceActivity extends android.preference.PreferenceActivity implements OnSharedPreferenceChangeListener {
	
	private EditTextPreference _pref_serverIP;
	private EditTextPreference _pref_serverPort;
//	private CheckBoxPreference _pref_serverReconnect;
	private EditTextPreference _pref_serverReconnectInterval;
	private EditTextPreference _pref_graphLength;
	private SharedPreferences sharedPrefs;
	
	@Override
	public void onCreate(Bundle savedInstanceState) {    
	    super.onCreate(savedInstanceState);       
	    addPreferencesFromResource(R.xml.preference);
	    
	    _pref_serverIP = (EditTextPreference) findPreference("pref_serverIP");
	    _pref_serverPort = (EditTextPreference) findPreference("pref_serverPort");
//	    _pref_serverReconnect = (CheckBoxPreference) findPreference("pref_serverReconnect");
	    _pref_serverReconnectInterval  = (EditTextPreference) findPreference("pref_serverReconnectInterval");
	    _pref_graphLength = (EditTextPreference) findPreference("pref_graphLength");
	    
	    sharedPrefs = PreferenceManager.getDefaultSharedPreferences(this);
	}

	@Override
	public void onResume() {
		super.onResume();
		
		// Set the summary text to the current value
		_pref_serverIP.setSummary("Current Value: " + sharedPrefs.getString("pref_serverIP", ""));
		_pref_serverPort.setSummary("Current Value: " + sharedPrefs.getString("pref_serverPort", ""));
		_pref_serverReconnectInterval.setSummary("Current Value: " + sharedPrefs.getString("pref_serverReconnectInterval", ""));
		_pref_graphLength.setSummary("Current Value: " + sharedPrefs.getString("pref_graphLength", ""));
		
		_pref_serverPort.getEditText().setInputType(InputType.TYPE_CLASS_NUMBER);
		_pref_graphLength.getEditText().setInputType(InputType.TYPE_CLASS_NUMBER);
		_pref_serverReconnectInterval.getEditText().setInputType(InputType.TYPE_CLASS_NUMBER);
		
		getPreferenceScreen().getSharedPreferences().registerOnSharedPreferenceChangeListener(this);
	}
	
	@Override
	public void onPause() {
		super.onPause();
		getPreferenceScreen().getSharedPreferences().unregisterOnSharedPreferenceChangeListener(this);
	}
	
	@Override
	public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
		// Change the summary text when the value is changed
		if (key.compareTo("pref_serverIP") == 0) {
			_pref_serverIP.setSummary("Current Value: " + sharedPreferences.getString(key, ""));
		} else if (key.compareTo("pref_serverPort") == 0) {
			_pref_serverPort.setSummary("Current Value: " + sharedPreferences.getString(key, ""));
		} else if (key.compareTo("pref_serverReconnectInterval") == 0) {
			_pref_serverReconnectInterval.setSummary("Current Value: " + sharedPreferences.getString(key, ""));
		} else if (key.compareTo("pref_graphLength") == 0) {
			_pref_graphLength.setSummary("Current Value: " + sharedPrefs.getString("pref_graphLength", ""));
		}
		
	}
}
