package ioio.debugger;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.CompoundButton;
import android.widget.CompoundButton.OnCheckedChangeListener;
import android.widget.ToggleButton;
import ioio.lib.api.AnalogInput;
import ioio.lib.api.DigitalInput;
import ioio.lib.api.DigitalOutput;
import ioio.lib.api.IOIO;
import ioio.lib.api.exception.ConnectionLostException;

public class CreateWidget {
	
	public static void addIA(final Integer pin, final long freq) {
		
		if (!IOIODebuggerActivity.getConnected())
			return;
		
		Context ctx = IOIODebuggerActivity.getContext();
		LayoutInflater inflater = (LayoutInflater) ctx.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		View v = inflater.inflate(R.layout.view_graph_text_widget, IOIODebuggerActivity._viewGroupGraphTextWidget);
		
		final ViewWidgetGraphText viewWidget = new ViewWidgetGraphText();
		SharedPreferences sharedPrefs = PreferenceManager.getDefaultSharedPreferences(ctx);
		viewWidget.setView(v, false, Integer.parseInt(sharedPrefs.getString("pref_graphLength", "100")));
		
		final NetworkClientConnectionHandler networkMgr = IOIODebuggerActivity.get_networkMgr();
		final Double[] data = new Double[1];
		
		Runnable r = new Runnable() {
			
			@Override
			public void run() {
				
				IOIODebuggerActivity.addOpenedPin(pin);
				viewWidget.setPin(pin);
				viewWidget.resetStopSignal();
				if (networkMgr.connectedOk())
					networkMgr.notifyStartIA(pin, freq);
				IOIO ioio = IOIODebuggerActivity.getIOIOInstance();
				AnalogInput in = null;
				Float volts;
				try {
					in = ioio.openAnalogInput(pin);
					viewWidget.updateStatus("Pin #" + pin.toString() + " : In : Analog : 3.3v");
					while (true) {
						if (Thread.currentThread().isInterrupted()) {
							in.close();
							viewWidget.setStopSignal();
							IOIODebuggerActivity.removeOpenedPin(pin);
							if (networkMgr.connectedOk())
								networkMgr.notifyStopPin(pin);
							break;
						}
						volts = in.getVoltage();
						viewWidget.updateText("Current Voltage: " + volts.toString());
						viewWidget.updateData((double)volts);
						viewWidget.refreshGraph();
						if (networkMgr.connectedOk()) {
							data[0] = (double)volts;
							networkMgr.sendData(pin, data);
						}
						Thread.sleep(freq);
					}
				} catch (ConnectionLostException e) {
					viewWidget.updateStatus("Connection Lost");
				} catch (InterruptedException e) {
					if (in != null)
						in.close();
					viewWidget.setStopSignal();
					IOIODebuggerActivity.removeOpenedPin(pin);
					if (networkMgr.connectedOk())
						networkMgr.notifyStopPin(pin);
				} catch (Exception e) {
					
				}
			}
		};
		viewWidget.setRunnable(r);
		IOIODebuggerActivity.setViewWidget(viewWidget);
	}
	
	public static void addID(final Integer pin, final long freq, final String mode) {
		
		if (!IOIODebuggerActivity.getConnected())
			return;
		
		Context ctx = IOIODebuggerActivity.getContext();
		LayoutInflater inflater = (LayoutInflater) ctx.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		View v = inflater.inflate(R.layout.view_graph_text_widget, IOIODebuggerActivity._viewGroupGraphTextWidget);
		
		final ViewWidgetGraphText viewWidget = new ViewWidgetGraphText();
		SharedPreferences sharedPrefs = PreferenceManager.getDefaultSharedPreferences(ctx);
		viewWidget.setView(v, true, Integer.parseInt(sharedPrefs.getString("pref_graphLength", "100")));
		
		final NetworkClientConnectionHandler networkMgr = IOIODebuggerActivity.get_networkMgr();
		final Double[] data = new Double[1];
		
		Runnable r = new Runnable() {
			
			@Override
			public void run() {
				IOIODebuggerActivity.addOpenedPin(pin);
				if (networkMgr.connectedOk())
					networkMgr.notifyStartID(pin, freq, mode);
				viewWidget.setPin(pin);
				viewWidget.resetStopSignal();
				IOIO ioio = IOIODebuggerActivity.getIOIOInstance();
				DigitalInput in = null;
				viewWidget.updateStatus("Pin #" + pin.toString() + " : In : Digital : 3.3v : " + mode);
				try {
					if (mode.compareTo("Float") == 0) {
						in = ioio.openDigitalInput(pin, DigitalInput.Spec.Mode.FLOATING);
					} else if (mode.compareTo("Pull Down") == 0) {
						in = ioio.openDigitalInput(pin, DigitalInput.Spec.Mode.PULL_DOWN);
					} else if (mode.compareTo("Pull Up") == 0) {
						in = ioio.openDigitalInput(pin, DigitalInput.Spec.Mode.PULL_UP);
					}
					while (true) {
						if (Thread.currentThread().isInterrupted()) {
							in.close();
							viewWidget.setStopSignal();
							IOIODebuggerActivity.removeOpenedPin(pin);
							if (networkMgr.connectedOk())
								networkMgr.notifyStopPin(pin);
							break;
						}
						if (in.read()) {
							viewWidget.updateText("Current Input: High");
							viewWidget.updateData(3.3);
							if (networkMgr.connectedOk()) {
								data[0] = 3.3;
								networkMgr.sendData(pin, data);
							}
						} else {
							viewWidget.updateText("Current Input: Low");
							viewWidget.updateData(0.0);
							if (networkMgr.connectedOk()) {
								data[0] = 0.0;
								networkMgr.sendData(pin, data);
							}
						}
						viewWidget.refreshGraph();
						Thread.sleep(freq);
					}
				} catch (ConnectionLostException e) {
					viewWidget.updateStatus("Connection Lost");
				} catch (InterruptedException e) {
					if (in != null)
						in.close();
					viewWidget.setStopSignal();
					IOIODebuggerActivity.removeOpenedPin(pin);
					if (networkMgr.connectedOk())
						networkMgr.notifyStopPin(pin);
				}
			}
		};
		viewWidget.setRunnable(r);
		IOIODebuggerActivity.setViewWidget(viewWidget);
	}
	
	public static void addOD(final Integer pin, final String mode, final boolean openDrain) {
		
		if (!IOIODebuggerActivity.getConnected())
			return;
		
		Context ctx = IOIODebuggerActivity.getContext();
		LayoutInflater inflater = (LayoutInflater) ctx.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		View v = inflater.inflate(R.layout.view_toggle_text_widget, IOIODebuggerActivity._viewGroupToggleTextWidget);
		
		final ViewWidgetToggleText viewWidget = new ViewWidgetToggleText();
		viewWidget.setView(v);
		
		ToggleButton toggle = (ToggleButton) viewWidget.getView().findViewById(R.id.layout_toggleText_toggle);
		if (mode.compareTo("High") == 0)
			toggle.setChecked(true);
		else
			toggle.setChecked(false);
		
		final NetworkClientConnectionHandler networkMgr = IOIODebuggerActivity.get_networkMgr();
		final Double[] data = new Double[1];
		
		Runnable r = new Runnable() {
			
			boolean outputHigh;
			IOIO ioio;
			DigitalOutput out;
			
			@Override
			public void run() {
				IOIODebuggerActivity.addOpenedPin(pin);
				if (networkMgr.connectedOk())
					networkMgr.notifyStartOD(pin, mode, openDrain);
				viewWidget.setPin(pin);
				viewWidget.resetStopSignal();
				if (mode.compareTo("High") == 0)
					outputHigh = true;
				else
					outputHigh = false;
				if (networkMgr.connectedOk()) {
					if (outputHigh)
						data[0] = 3.3;
					else
						data[0] = 0.0;
					networkMgr.sendData(pin, data);
				}
				viewWidget.setToggle(outputHigh);
				ioio = IOIODebuggerActivity.getIOIOInstance();
				
				try {
					if (openDrain && outputHigh)
						out = ioio.openDigitalOutput(pin, DigitalOutput.Spec.Mode.OPEN_DRAIN, true);
					else if (openDrain && !outputHigh)
						out = ioio.openDigitalOutput(pin, DigitalOutput.Spec.Mode.OPEN_DRAIN, false);
					else if (!openDrain && outputHigh)
						out = ioio.openDigitalOutput(pin, DigitalOutput.Spec.Mode.NORMAL, true);
					else // (!openDrain && !outputHigh)
						out = ioio.openDigitalOutput(pin, DigitalOutput.Spec.Mode.NORMAL, false);
					
					if (openDrain)
						viewWidget.updateStatus("Pin #" + pin.toString() + " : Out : Digital : OD : 3.3v");
					else
						viewWidget.updateStatus("Pin #" + pin.toString() + " : Out : Digital : 3.3v");
					
					ToggleButton toggle = (ToggleButton)viewWidget.getView().findViewById(R.id.layout_toggleText_toggle);
					if (toggle.isChecked())
						outputHigh = true;
					else
						outputHigh = false;
					toggle.setOnCheckedChangeListener(new OnCheckedChangeListener() {
						
						@Override
						public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
							if (isChecked) {
								outputHigh = true;
							} else {
								outputHigh = false;
							}
							if (networkMgr.connectedOk()) {
								if (outputHigh)
									data[0] = 3.3;
								else
									data[0] = 0.0;
								networkMgr.sendData(pin, data);
							}
						}
					});
					
					while (true) {
						if (Thread.currentThread().isInterrupted()) {
							out.close();
							viewWidget.setStopSignal();
							IOIODebuggerActivity.removeOpenedPin(pin);
							if (networkMgr.connectedOk())
								networkMgr.notifyStopPin(pin);
							break;
						}
						if (outputHigh) {
							viewWidget.updateText("Current Output: HIGH");
							out.write(true);
						} else {
							viewWidget.updateText("Current Output: LOW");
							out.write(false);
						}
						viewWidget.setToggle(outputHigh);
						Thread.sleep(50);
					}
				} catch (ConnectionLostException e) {
					viewWidget.updateStatus("Connection Lost");
				} catch (InterruptedException e) {
					if (out != null)
						out.close();
					viewWidget.setStopSignal();
					IOIODebuggerActivity.removeOpenedPin(pin);
					if (networkMgr.connectedOk())
						networkMgr.notifyStopPin(pin);
				} catch (Exception e) {
					
				}
			}
		};
		viewWidget.setRunnable(r);
		IOIODebuggerActivity.setViewWidget(viewWidget);
	}
}
