package ioio.debugger;

import android.graphics.Color;
import android.os.Handler;
import android.view.View;
import android.widget.TextView;

public class ViewWidgetToggleText implements ViewWidget {

	private View view;
	private Runnable run;
	private Thread thread;
	private Handler handler = new Handler();
	private int pin;
	private boolean toggle;

	public ViewWidgetToggleText() {
		
	}
	
	@Override
	public void stopThread() {
		thread.interrupt();
	}
	
	@Override
	public void startThread() {
		// Kill the thread if it is already running
		if (thread != null && thread.isAlive())
			thread.interrupt();
		// Start a new thread and run the passed Runnable
		thread = new Thread (run);
		thread.start();
	}
	
	@Override
	public View getView() {
		return view;
	}

	@Override
	public Thread getThread() {
		return thread;
	}
	
	@Override
	public void clearData() {
		
	}
	
	@Override
	public void setStopSignal() {
		handler.post(new Runnable() {
			
			@Override
			public void run() {
				TextView tv = (TextView)view.findViewById(R.id.layout_toggleText_status);
				tv.setTextColor(Color.RED);
			}
		});
	}
	
	@Override
	public void resetStopSignal() {
		handler.post(new Runnable() {
			
			@Override
			public void run() {
				TextView tv = (TextView)view.findViewById(R.id.layout_toggleText_status);
				tv.setTextColor(Color.WHITE);
			}
		});
	}
	
	@Override
	public void sendDataHistory() {
		Double[] data = new Double[1];
		if (toggle)
			data[0] = 3.3;
		else
			data[0] = 0.0;
		IOIODebuggerActivity.get_networkMgr().sendData(pin, data);
	}

	@Override
	public int getPin() {
		return pin;
	}
	
	public void setPin(int pin) {
		this.pin = pin;
	}
	
	public void updateText(final String str) {
		handler.post(new Runnable() {
			
			@Override
			public void run() {
				TextView tv = (TextView)view.findViewById(R.id.layout_toggleText_text);
				tv.setText(str);
			}
		});
	}
	
	public void updateStatus(final String str) {
		handler.post(new Runnable() {
			
			@Override
			public void run() {
				TextView tv = (TextView)view.findViewById(R.id.layout_toggleText_status);
				tv.setText(str);
			}
		});
	}

	public void setToggle(boolean b) {
		toggle = b;
	}
	
	public void setView(View view) {
		this.view = view;
	}
	
	public void setRunnable(Runnable r) {
		this.run = r;
	}
}
