package ioio.debugger;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

import android.app.Activity;
import android.os.Bundle;
import android.view.Gravity;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TableRow.LayoutParams;
import android.widget.TextView;

public class PinDetailActivity extends Activity {

	private TableLayout root;
	
	private int totalPins = 48;
	private HashSet<Integer> AD;
	private HashSet<Integer> PPSi;
	private HashSet<Integer> PPSo;
	private HashSet<Integer> FiveV;
	private HashMap<Integer, String> I2C = new HashMap<Integer, String>();
	private HashMap<Integer, String> Comp = new HashMap<Integer, String>();;
	
	@Override
	public void onCreate(Bundle savedInstanceState) {
	    super.onCreate(savedInstanceState);
	    setContentView(R.layout.pin_details);
	    
	    root = (TableLayout) findViewById(R.id.pin_table_root);
	    
	    Integer[] ad = {31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46};
	    AD = new HashSet<Integer>(Arrays.asList(ad));
	    Integer[] ppsi = {3,4,5,6,7,9,10,11,12,13,14,27,28,29,30,31,32,34,35,36,37,38,39,40,45,46,47,48};
	    PPSi = new HashSet<Integer>(Arrays.asList(ppsi));
	    Integer[] ppso = {3,4,5,6,7,10,11,12,13,14,27,28,29,30,31,32,34,35,36,37,38,39,40,45,46,47,48};
	    PPSo = new HashSet<Integer>(Arrays.asList(ppso));
	    Integer[] fiveV = {3,4,5,6,7,10,11,12,13,14,18,19,20,21,22,23,24,25,26,47,48};
	    FiveV = new HashSet<Integer>(Arrays.asList(fiveV));
	    
	    I2C.put(4, "DA0");
	    I2C.put(5, "CL0");
	    I2C.put(25, "DA2");
	    I2C.put(26, "CL2");
	    I2C.put(47, "DA1");
	    I2C.put(48, "CL1");
	    
	    Comp.put(8, "3D");
	    Comp.put(9, "3C");
	    Comp.put(15, "3B");
	    Comp.put(16, "3A");
	    Comp.put(27, "1D");
	    Comp.put(28, "1C");
	    Comp.put(29, "2D");
	    Comp.put(30, "2C");
	    Comp.put(31, "1A");
	    Comp.put(32, "1B");
	    Comp.put(33, "2A");
	    Comp.put(34, "2B");
	    
	    root.setStretchAllColumns(true);
	    
	    for (Integer i = 1; i <= totalPins; i++) {
	    	TableRow row = new TableRow(this);
	    	
	    	TextView tv = new TextView(this);
	    	tv.setLayoutParams(new LayoutParams(0, LayoutParams.WRAP_CONTENT, 1));
	    	tv.setGravity(Gravity.CENTER);
	    	
	    	tv.setText(String.valueOf(i));
	    	row.addView(tv);
	    	
	    	tv = new TextView(this);
	    	tv.setGravity(Gravity.CENTER);
	    	tv.setLayoutParams(new LayoutParams(0, LayoutParams.WRAP_CONTENT, 1));
	    	if (AD.contains(i))
	    		tv.setText("\u2713");
	    	else
	    		tv.setText("");
	    	row.addView(tv);
	    	
	    	tv = new TextView(this);
	    	tv.setGravity(Gravity.CENTER);
	    	tv.setLayoutParams(new LayoutParams(0, LayoutParams.WRAP_CONTENT, 1));
	    	if (I2C.containsKey(i))
	    		tv.setText(I2C.get(i));
	    	else
	    		tv.setText("");
	    	row.addView(tv);
	    	
	    	tv = new TextView(this);
	    	tv.setGravity(Gravity.CENTER);
	    	tv.setLayoutParams(new LayoutParams(0, LayoutParams.WRAP_CONTENT, 1));
	    	if (PPSi.contains(i))
	    		tv.setText("\u2713");
	    	else
	    		tv.setText("");
	    	row.addView(tv);
	    	
	    	tv = new TextView(this);
	    	tv.setGravity(Gravity.CENTER);
	    	tv.setLayoutParams(new LayoutParams(0, LayoutParams.WRAP_CONTENT, 1));
	    	if (PPSo.contains(i))
	    		tv.setText("\u2713");
	    	else
	    		tv.setText("");
	    	row.addView(tv);
	    	
	    	tv = new TextView(this);
	    	tv.setGravity(Gravity.CENTER);
	    	tv.setLayoutParams(new LayoutParams(0, LayoutParams.WRAP_CONTENT, 1));
	    	if (FiveV.contains(i))
	    		tv.setText("\u2713");
	    	else
	    		tv.setText("");
	    	row.addView(tv);
	    	
	    	tv = new TextView(this);
	    	tv.setGravity(Gravity.CENTER);
	    	tv.setLayoutParams(new LayoutParams(0, LayoutParams.WRAP_CONTENT, 1));
	    	if (Comp.containsKey(i))
	    		tv.setText(Comp.get(i));
	    	else
	    		tv.setText("");
	    	row.addView(tv);
	    	
	    	root.addView(row);
	    }
	}
}
