package ioio.debugger;

import java.util.LinkedList;
import com.androidplot.series.XYSeries;

public class GenericXYSeries implements XYSeries {
	private int length;
	private String title;
	private LinkedList<Number> data;
	
	public GenericXYSeries(String str, int len) {
		title = str;
		length = len;
		data = new LinkedList<Number>();
	}
	
	@Override
	public String getTitle() {
		return title;
	}

	@Override
	public int size() {
		return length;
	}

	@Override
	public Number getX(int index) {
		return index;
	}

	@Override
	public Number getY(int index) {
		if (index >= data.size())
			return 0;
		else
			return data.get(index);
	}
	
	public void addDataToList(Number num) {
		if (data.size() > length)
			data.removeFirst();
		data.addLast(num);
	}
	
	public void clearData() {
		data.clear();
	}
	
	public LinkedList<Number> getData() {
		return data;
	}
}
