package ioio.debugger;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.Spinner;
import android.widget.Toast;

public class AddODActivity extends Activity implements OnClickListener {

	private Spinner _spinnerPin;
	private Spinner _spinnerMode;
	private CheckBox _checkMode;
	private Button _btnAdd;
	
	private Integer pin;
	private String mode;
	private boolean openDrain;
	
	/** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.class_od_activity);
        
        _spinnerPin = (Spinner)findViewById(R.id.ODspinnerPin);
        _spinnerMode = (Spinner)findViewById(R.id.ODspinnerLevel);
        _checkMode = (CheckBox)findViewById(R.id.ODopenDrainMode);
        _btnAdd = (Button)findViewById(R.id.ODbuttonAdd);
        
        _btnAdd.setOnClickListener(this);
        
        ArrayAdapter<CharSequence> adapterPin = ArrayAdapter.createFromResource(this, R.array.digital_pins, android.R.layout.simple_spinner_item);
        adapterPin.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        _spinnerPin.setAdapter(adapterPin);
        
        ArrayAdapter<CharSequence> adapterMode = ArrayAdapter.createFromResource(this, R.array.digital_out_mode, android.R.layout.simple_spinner_item);
        adapterMode.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        _spinnerMode.setAdapter(adapterMode);
        
        _spinnerPin.setOnItemSelectedListener(new OnItemSelectedListener() {

			@Override
			public void onItemSelected(AdapterView<?> parent, View view, int pos, long id) {
				String str = parent.getItemAtPosition(pos).toString();
				pin = Integer.parseInt(str);
			}

			@Override
			public void onNothingSelected(AdapterView<?> arg0) {
				// Do Nothing
			}
		});
        
        _spinnerMode.setOnItemSelectedListener(new OnItemSelectedListener() {

			@Override
			public void onItemSelected(AdapterView<?> parent, View view, int pos, long id) {
				mode = parent.getItemAtPosition(pos).toString();
			}

			@Override
			public void onNothingSelected(AdapterView<?> arg0) {
				// Do Nothing
			}
		});
    }

	@Override
	public void onClick(View v) {
		
		openDrain = _checkMode.isChecked();
		
		for (Integer i : IOIODebuggerActivity.getOpenedPins()) {
			if (i == pin) {
				Toast.makeText(this, "Specified pin has already been opened", Toast.LENGTH_SHORT).show();
				return;
			}
		}
		
		CreateWidget.addOD(pin, mode, openDrain);
		
		setResult(RESULT_OK);
		finish();
	}
}
