package ioio.debugger;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.Spinner;
import android.widget.Toast;
import android.widget.AdapterView.OnItemSelectedListener;

public class AddIDActivity extends Activity implements OnClickListener{

	private Spinner _spinnerPin;
	private Spinner _spinnerFreq;
	private Spinner _spinnerMode;
	private Button _btnAdd;
	
	private Integer pin;
	private long freq;
	private String mode;
	
	/** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.class_id_activity);
        
        _spinnerPin = (Spinner)findViewById(R.id.IDspinnerPin);
        _spinnerFreq = (Spinner)findViewById(R.id.IDspinnerFreq);
        _spinnerMode = (Spinner)findViewById(R.id.IDspinnerMode);
        _btnAdd = (Button)findViewById(R.id.IDbuttonAdd);
        
        _btnAdd.setOnClickListener(this);
        
        ArrayAdapter<CharSequence> adapterPin = ArrayAdapter.createFromResource(this, R.array.digital_pins, android.R.layout.simple_spinner_item);
        adapterPin.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        _spinnerPin.setAdapter(adapterPin);
        
        ArrayAdapter<CharSequence> adapterFreq = ArrayAdapter.createFromResource(this, R.array.refresh_rate, android.R.layout.simple_spinner_item);
        adapterFreq.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        _spinnerFreq.setAdapter(adapterFreq);
        
        ArrayAdapter<CharSequence> adapterMode = ArrayAdapter.createFromResource(this, R.array.digital_in_mode, android.R.layout.simple_spinner_item);
        adapterMode.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        _spinnerMode.setAdapter(adapterMode);
        
        _spinnerPin.setOnItemSelectedListener(new OnItemSelectedListener() {

			@Override
			public void onItemSelected(AdapterView<?> parent, View view, int pos, long id) {
				String str = parent.getItemAtPosition(pos).toString();
				pin = Integer.parseInt(str);
			}

			@Override
			public void onNothingSelected(AdapterView<?> arg0) {
				// Do Nothing
			}
		});
        
        _spinnerFreq.setOnItemSelectedListener(new OnItemSelectedListener() {

			@Override
			public void onItemSelected(AdapterView<?> parent, View view, int pos, long id) {
				String str = parent.getItemAtPosition(pos).toString();
				double val = Double.parseDouble(str);
				freq = (long)(val*1000);
			}

			@Override
			public void onNothingSelected(AdapterView<?> arg0) {
				// Do Nothing
			}
		});
        
        _spinnerMode.setOnItemSelectedListener(new OnItemSelectedListener() {

			@Override
			public void onItemSelected(AdapterView<?> parent, View view, int pos, long id) {
				mode = parent.getItemAtPosition(pos).toString();
			}

			@Override
			public void onNothingSelected(AdapterView<?> arg0) {
				// Do Nothing
			}
		});
    }
    
	@Override
	public void onClick(View v) {
		
		for (Integer i : IOIODebuggerActivity.getOpenedPins()) {
			if (i == pin) {
				Toast.makeText(this, "Specified pin has already been opened", Toast.LENGTH_SHORT).show();
				return;
			}
		}

		CreateWidget.addID(pin, freq, mode);
		
		setResult(RESULT_OK);
		finish();	
	}

}
