package ioio.debugger;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.Spinner;
import android.widget.Toast;

public class AddIAActivity extends Activity implements OnClickListener {

	private Spinner _spinnerPin;
	private Spinner _spinnerFreq;
	private Button _btnAdd;
	
	private Integer pin;
	private long freq;
	
	/** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.class_ia_activity);
        
        _spinnerPin = (Spinner)findViewById(R.id.IAspinnerPin);
        _spinnerFreq = (Spinner)findViewById(R.id.IAspinnerFreq);
        _btnAdd = (Button)findViewById(R.id.IAbuttonAdd);
        
        _btnAdd.setOnClickListener(this);
        
        ArrayAdapter<CharSequence> adapterPin = ArrayAdapter.createFromResource(this, R.array.analog_pins, android.R.layout.simple_spinner_item);
        adapterPin.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        _spinnerPin.setAdapter(adapterPin);
        
        ArrayAdapter<CharSequence> adapterFreq = ArrayAdapter.createFromResource(this, R.array.refresh_rate, android.R.layout.simple_spinner_item);
        adapterFreq.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        _spinnerFreq.setAdapter(adapterFreq);
        
        _spinnerPin.setOnItemSelectedListener(new OnItemSelectedListener() {

			@Override
			public void onItemSelected(AdapterView<?> parent, View view, int pos, long id) {
				String str = parent.getItemAtPosition(pos).toString();
				pin = Integer.parseInt(str);
			}

			@Override
			public void onNothingSelected(AdapterView<?> arg0) {
				// Do Nothing
			}
		});
        
        _spinnerFreq.setOnItemSelectedListener(new OnItemSelectedListener() {

			@Override
			public void onItemSelected(AdapterView<?> parent, View view, int pos, long id) {
				String str = parent.getItemAtPosition(pos).toString();
				double val = Double.parseDouble(str);
				freq = (long)(val*1000);
			}

			@Override
			public void onNothingSelected(AdapterView<?> arg0) {
				// Do Nothing
			}
		});
    }

	@Override
	public void onClick(View v) {
		
		for (Integer i : IOIODebuggerActivity.getOpenedPins()) {
			if (i == pin) {
				Toast.makeText(this, "Specified pin has already been opened", Toast.LENGTH_SHORT).show();
				return;
			}
		}

		CreateWidget.addIA(pin, freq);
		
		setResult(RESULT_OK);
		finish();
	}
}
